/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.DinosaurEntities;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;

public class AnkylosaurusEntity
extends DinosaurEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(AnkylosaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public AnkylosaurusEntity(Level world, EntityType<AnkylosaurusEntity> type) {
        super(world, type, DinosaurHandler.ANKYLOSAURUS);
        this.addTask(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.setVariant(this.m_21187_().nextInt(4));
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.ANKYLOSAURUS_LIVING;
            }
            case DYING: {
                return SoundHandler.ANKYLOSAURUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.ANKYLOSAURUS_HURT;
            }
            case CALLING: {
                return SoundHandler.ANKYLOSAURUS_CALL;
            }
            case ROARING: {
                return SoundHandler.ANKYLOSAURUS_CALL;
            }
            case ATTACKING: {
                return SoundHandler.ANKYLOSAURUS_ATTACK;
            }
            case MATING: {
                return SoundHandler.ANKYLOSAURUS_MATE_CALL;
            }
        }
        return null;
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(VARIANT, (Object)nbt.m_128451_("Variant"));
    }

    public void setVariant(int value) {
        this.f_19804_.m_135381_(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public ResourceLocation getTexture() {
        switch (this.getVariant()) {
            default: {
                return this.texture("bumpy");
            }
            case 1: {
                return this.texture("jw");
            }
            case 2: {
                return this.texture("jp3");
            }
            case 3: 
        }
        return this.texture("swamp");
    }

    private ResourceLocation texture(String variant) {
        String formattedName = this.dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + formattedName + "/";
        String texture = baseTextures + formattedName;
        return this.isMale() ? new ResourceLocation("jurassicreborn", texture + "_male_adult_" + variant + ".png") : new ResourceLocation("jurassicreborn", texture + "_female_adult_" + variant + ".png");
    }
}

