/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.AlligatorGarEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.FoodType;
import net.vit.jurassicreborn.common.entities.EntityUtils.MovementType;
import net.vit.jurassicreborn.common.entities.EntityUtils.SleepTime;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class AlligatorGarDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public AlligatorGarDinosaur() {
        this.setName("Alligator Gar");
        this.setScientificName("Atractosteus spatula");
        this.setFamily("Lepisosteidae");
        this.setLocation("North America");
        this.setDinosaurType(Dinosaur.DinosaurType.PASSIVE);
        this.setDinosaurClass(AlligatorGarEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(7371668, 3885411);
        this.setEggColorFemale(8157022, 5065275);
        this.setHealth(2.0, 10.0);
        this.setFlee(true);
        this.setSpeed(0.25000000596046446, 0.4f);
        this.setAttackSpeed(1.5);
        this.setStrength(0.5, 3.0);
        this.setMaximumAge(this.fromDays(30));
        this.setEyeHeight(0.18f, 0.9f);
        this.setSizeX(0.2f, 1.0f);
        this.setSizeY(0.2f, 1.0f);
        this.setDiet(Diet.PISCIVORE.get().withModule(new Diet.DietModule(FoodType.FILTER)));
        this.setSleepTime(SleepTime.NO_SLEEP);
        this.setBones("anal_fin", "dorsal_fin", "pectoral_fin_bones", "pelvic_fin_bones", "scales", "skull", "spine", "tail_fin", "teeth");
        this.setHeadCubeName("Head");
        this.setScale(0.95f, 0.15f);
        this.setMaxHerdSize(30);
        this.setOffset(0.0f, 0.5f, 0.0f);
        this.setAttackBias(100.0);
        this.setBreeding(true, 2, 12, 40, false, true);
        this.setMarineAnimal(true);
        this.setMovementType(MovementType.NEAR_SURFACE);
        this.setRandomFlock(false);
        this.setImprintable(false);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        String[][] recipe = new String[][]{{"", "dorsal_fin", "scales", ""}, {"tail_fin", "spine", "pectoral_fin_bones", "skull"}, {"anal_fin", "", "pelvic_fin_bones", "teeth"}};
        this.setRecipe(recipe);
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_WATER, BiomeTags.f_207603_, BiomeTags.f_207605_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
        this.enableSkeleton();
    }

    @Override
    public List<MobEffectInstance> applyMeatEffect(List<MobEffectInstance> player, boolean cooked) {
        if (!cooked) {
            player.add(new MobEffectInstance(MobEffects.f_19614_, 400, 1));
        }
        player.add(new MobEffectInstance(MobEffects.f_19604_, 200, 1));
        return player;
    }
}

