/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DiplocaulusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class DiplocaulusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.3f;

    public DiplocaulusDinosaur() {
        this.setName("Diplocaulus");
        this.setScientificName("Diplocaulus minimus");
        this.setFamily("Diplocaulidae");
        this.setLocation("United States");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(DiplocaulusEntity.class);
        this.setTimePeriod(TimePeriod.PERMIAN);
        this.setEggColorMale(12442078, 2648703);
        this.setEggColorFemale(13491943, 2644096);
        this.setHealth(2.0, 10.0);
        this.setSpeed(0.25000001192092897, 0.3f);
        this.setStorage(18);
        this.setStrength(1.0, 4.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.25f, 0.55f);
        this.setSizeX(0.1f, 1.0f);
        this.setSizeY(0.3f, 0.6f);
        this.setDiet(Diet.PISCIVORE.get());
        this.setBones("skull", "teeth", "foot_bone", "leg_bones", "ribcage", "tail_vertebrae");
        this.setHeadCubeName("Head");
        this.setScale(0.2f, 0.05f);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.setOffset(0.0f, -1.5f, 0.0f);
        this.setAttackBias(10.0);
        this.setImprintable(true);
        this.setBreeding(true, 2, 6, 20, false, true);
        this.setMarineAnimal(true);
        String[][] recipe = new String[][]{{"", "", "skull"}, {"tail_vertebrae", "ribcage", "teeth"}, {"leg_bones", "", "leg_bones"}, {"", "", "foot_bone"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_WATER, BiomeTags.f_207603_, BiomeTags.f_207605_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

