/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DunkleosteusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.SleepTime;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class DunkleosteusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.45f;

    public DunkleosteusDinosaur() {
        this.setName("Dunkleosteus");
        this.setScientificName("Dunkleosteus terrelli");
        this.setFamily("Dunkleosteidae");
        this.setLocation("United States");
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setDinosaurClass(DunkleosteusEntity.class);
        this.setTimePeriod(TimePeriod.DEVONIAN);
        this.setEggColorMale(11049868, 7682600);
        this.setEggColorFemale(10921352, 7888682);
        this.setHealth(16.0, 60.0);
        this.setSpeed(0.34999998807907107, 0.45f);
        this.setStrength(10.0, 40.0);
        this.setMaximumAge(this.fromDays(30));
        this.setEyeHeight(0.15f, 1.9f);
        this.setSizeX(0.3f, 2.7f);
        this.setSizeY(0.2f, 2.0f);
        this.setMarineAnimal(true);
        this.setStorage(27);
        this.setDiet(Diet.CARNIVORE.get());
        this.setSleepTime(SleepTime.DIURNAL);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.setBones("mouth_plates", "skull", "dorsal_fin", "spine");
        this.setHeadCubeName("Main head");
        this.setScale(1.2f, 0.15f);
        this.shouldDefendOffspring();
        this.setAttackBias(420.0);
        this.setImprintable(false);
        this.setBreeding(true, 2, 6, 20, false, true);
        String[][] recipe = new String[][]{{"", "", "dorsal_fin", "", ""}, {"spine", "spine", "spine", "skull", "mouth_plates"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_WATER, BiomeTags.f_207603_, BiomeTags.f_207605_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

