/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MaiasauraEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class MaiasauraDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.41f;

    public MaiasauraDinosaur() {
        this.setName("Maiasaura");
        this.setScientificName("Maiasaura peeblesorum");
        this.setFamily("Hadrosauridae");
        this.setLocation("Canada");
        this.setDinosaurType(Dinosaur.DinosaurType.PASSIVE);
        this.setDinosaurClass(MaiasauraEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(0x1F1F1F, 0x888888);
        this.setEggColorFemale(2630431, 9801354);
        this.setHealth(10.0, 60.0);
        this.setStrength(5.0, 20.0);
        this.setSpeed(0.3599999964237213, 0.41f);
        this.setMaximumAge(this.fromDays(50));
        this.setEyeHeight(0.56f, 2.75f);
        this.setSizeX(0.3f, 2.4f);
        this.setSizeY(0.6f, 3.0f);
        this.setStorage(45);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("cheek_teeth", "pelvis", "skull", "front_leg_bones", "hind_leg_bones", "ribcage", "shoulder", "tail_vertebrae", "neck_vertebrae");
        this.setHeadCubeName("Head");
        this.setScale(0.95f, 0.1f);
        this.setAttackBias(80.0);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setFlockSpeed(1.5f);
        this.setBreeding(false, 4, 6, 40, false, true);
        String[][] recipe = new String[][]{{"tail_vertebrae", "pelvis", "ribcage", "neck_vertebrae", "skull"}, {"hind_leg_bones", "", "", "shoulder", "cheek_teeth"}, {"", "", "", "", "front_leg_bones"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207607_, BiomeTags.f_207592_, Tags.Biomes.IS_SANDY};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

