/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MawsoniaEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.MovementType;
import net.vit.jurassicreborn.common.entities.EntityUtils.SleepTime;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class MawsoniaDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public MawsoniaDinosaur() {
        this.setName("Mawsonia");
        this.setScientificName("Mawsonia gigas");
        this.setFamily("Mawsoniidae");
        this.setLocation("Brazil");
        this.setDinosaurClass(MawsoniaEntity.class);
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(7371668, 3885411);
        this.setEggColorFemale(8157022, 5065275);
        this.setHealth(6.0, 40.0);
        this.setFlee(true);
        this.setSpeed(0.3000000059604645, 0.4f);
        this.setAttackSpeed(1.5);
        this.setStrength(0.5, 3.0);
        this.setMaximumAge(this.fromDays(30));
        this.setEyeHeight(0.15f, 1.8f);
        this.setSizeX(0.3f, 2.5f);
        this.setSizeY(0.2f, 1.8f);
        this.setDiet(Diet.PCARNIVORE.get());
        this.setSleepTime(SleepTime.NO_SLEEP);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.setBones("anal_fin", "caudal_fin", "first_dorsal_fin", "pectoral_fin_bones", "pelvic_fin_bones", "second_dorsal_fin", "skull", "spine", "teeth");
        this.setHeadCubeName("Main head");
        this.setScale(1.8f, 0.1f);
        this.setMaxHerdSize(4);
        this.setOffset(0.0f, 0.9f, -0.2f);
        this.setAttackBias(100.0);
        this.setMarineAnimal(true);
        this.setMovementType(MovementType.DEEP_WATER);
        this.setBreeding(true, 2, 4, 15, true, false);
        this.setRandomFlock(true);
        String[][] recipe = new String[][]{{"", "second_dorsal_fin", "first_dorsal_fin", ""}, {"caudal_fin", "spine", "pectoral_fin_bones", "skull"}, {"anal_fin", "", "pelvic_fin_bones", "teeth"}};
        this.setRecipe(recipe);
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_WATER, BiomeTags.f_207603_, BiomeTags.f_207605_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
        this.enableSkeleton();
    }

    @Override
    public List<MobEffectInstance> applyMeatEffect(List<MobEffectInstance> player, boolean cooked) {
        if (!cooked) {
            player.add(new MobEffectInstance(MobEffects.f_19614_, 400, 1));
        }
        player.add(new MobEffectInstance(MobEffects.f_19604_, 200, 1));
        return player;
    }
}

