/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.MegatheriumEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class MegatheriumDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.3f;

    public MegatheriumDinosaur() {
        this.setName("Megatherium");
        this.setScientificName("Megatherium americanum");
        this.setFamily("Megatheriidae");
        this.setLocation("South America");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(MegatheriumEntity.class);
        this.setTimePeriod(TimePeriod.NEOGENE);
        this.setEggColorMale(6111756, 11309403);
        this.setEggColorFemale(0xB7B7B7, 0x151515);
        this.setHealth(12.0, 50.0);
        this.setSpeed(0.25000001192092897, 0.3f);
        this.setStorage(27);
        this.setAttackSpeed(1.1);
        this.setStrength(2.0, 10.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.45f, 2.3f);
        this.setSizeX(0.35f, 2.1f);
        this.setSizeY(0.5f, 2.4f);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("skull", "teeth", "arm_bones", "hind_leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "tail_vertebrae");
        this.setHeadCubeName("Head");
        this.setScale(2.0f, 0.4f);
        this.setMammal(true);
        this.setBirthType(Dinosaur.BirthType.LIVE_BIRTH);
        this.shouldDefendOffspring();
        this.setAttackBias(400.0);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setBreeding(true, 2, 4, 40, false, true);
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", "teeth"}, {"", "", "hind_leg_bones", "arm_bones", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{BiomeTags.f_207592_, Tags.Biomes.IS_CONIFEROUS, BiomeTags.f_207606_, Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, Tags.Biomes.IS_SNOWY};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

