/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.PachycephalosaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class PachycephalosaurusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public PachycephalosaurusDinosaur() {
        this.setName("Pachycephalosaurus");
        this.setScientificName("Pachycephalosaurus wyomingensis");
        this.setFamily("Pachycephalosauridae");
        this.setLocation("United States");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(PachycephalosaurusEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(14279104, 9523231);
        this.setEggColorFemale(9338974, 4870484);
        this.setHealth(10.0, 50.0);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setStrength(4.0, 10.0);
        this.setMaximumAge(this.fromDays(40));
        this.setSizeX(0.15f, 1.25f);
        this.setSizeY(0.4f, 2.3f);
        this.setStorage(27);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("skull", "teeth", "ribcage", "leg_bones", "neck_vertebrae", "pelvis", "shoulder", "tail_vertebrae");
        this.setHeadCubeName("Head");
        this.setScale(0.9f, 0.1f);
        this.setEyeHeight(0.35f, 2.2f);
        this.setAttackBias(400.0);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setBreeding(false, 2, 6, 40, false, true);
        String[][] recipe = new String[][]{{"", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder"}, {"leg_bones", "leg_bones", "", "teeth"}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, Tags.Biomes.IS_CONIFEROUS, Tags.Biomes.IS_DRY};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey((IForgeRegistryEntry)biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

