/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceBaseBlock;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFencePoleBlock;
import net.vit.jurassicreborn.common.blocks.entities.fence.ElectricFenceWireBlock;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.ai.util.AIUtils;

public class EscapeWireEntityAI
extends Goal {
    private static final int START_RADIUS = 4;
    private static final int MAX_RADIUS = 24;
    private static final int RADIUS_STEP = 4;
    private static final int SAFE_CLEARANCE = 2;
    private static final int RECALC_TICKS = 20;
    private static final int STUCK_CHECK_TICKS = 20;
    private static final double MIN_PROGRESS_SQ = 0.4;
    private static final int HARD_TIMEOUT_TICKS = 200;
    private final DinosaurEntity dino;
    private BlockPos target;
    private int nextRecalc;
    private int startedAtTick;
    private double lastX;
    private double lastZ;
    private int nextStuckCheck;

    public EscapeWireEntityAI(DinosaurEntity dino) {
        this.dino = dino;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return !this.dino.f_19853_.f_46443_ && this.dino.wireTicks > 0 && !this.dino.m_20159_() && this.dino.m_6084_();
    }

    public boolean m_8045_() {
        if (this.dino.f_19853_.f_46443_) {
            return false;
        }
        if (this.dino.f_19797_ - this.startedAtTick > 200) {
            return false;
        }
        return this.target != null && !this.dino.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.startedAtTick = this.dino.f_19797_;
        this.nextRecalc = 0;
        this.nextStuckCheck = this.dino.f_19797_ + 20;
        this.lastX = this.dino.m_20185_();
        this.lastZ = this.dino.m_20189_();
        this.dino.m_21573_().m_26573_();
        this.target = this.findSafeSpot();
        if (this.target != null) {
            this.dino.m_21573_().m_26519_((double)this.target.m_123341_() + 0.5, (double)this.target.m_123342_(), (double)this.target.m_123343_() + 0.5, 1.4);
        }
    }

    public void m_8041_() {
        this.target = null;
    }

    public void m_8037_() {
        if (this.target == null) {
            this.target = this.findSafeSpot();
            if (this.target == null) {
                return;
            }
            this.dino.m_21573_().m_26519_((double)this.target.m_123341_() + 0.5, (double)this.target.m_123342_(), (double)this.target.m_123343_() + 0.5, 1.4);
        }
        if (--this.nextRecalc <= 0) {
            this.nextRecalc = 20;
            this.dino.m_21573_().m_26519_((double)this.target.m_123341_() + 0.5, (double)this.target.m_123342_(), (double)this.target.m_123343_() + 0.5, 1.4);
        }
        if (this.dino.f_19797_ >= this.nextStuckCheck) {
            BlockPos newer;
            double dz;
            this.nextStuckCheck = this.dino.f_19797_ + 20;
            double dx = this.dino.m_20185_() - this.lastX;
            if (dx * dx + (dz = this.dino.m_20189_() - this.lastZ) * dz < 0.4 && (newer = this.findSafeSpot()) != null && !newer.equals((Object)this.target)) {
                this.target = newer;
                this.dino.m_21573_().m_26519_((double)this.target.m_123341_() + 0.5, (double)this.target.m_123342_(), (double)this.target.m_123343_() + 0.5, 1.4);
            }
            this.lastX = this.dino.m_20185_();
            this.lastZ = this.dino.m_20189_();
        }
    }

    private BlockPos findSafeSpot() {
        Level level = this.dino.f_19853_;
        Random rng = this.dino.m_21187_();
        BlockPos origin = this.dino.m_142538_();
        for (int radius = 4; radius <= 24; radius += 4) {
            for (int i = 0; i < 20; ++i) {
                BlockPos surface;
                BlockPos max;
                int offZ;
                int offX = rng.nextInt(radius * 2 + 1) - radius;
                BlockPos base = origin.m_142082_(offX, 0, offZ = rng.nextInt(radius * 2 + 1) - radius);
                BlockPos min = base.m_142082_(-2, -2, -2);
                if (!level.m_46832_(min, max = base.m_142082_(2, 2, 2)) || !EscapeWireEntityAI.isGoodFooting(level, surface = AIUtils.findSurface(level, base)) || EscapeWireEntityAI.hasFenceNearby(level, surface, 2)) continue;
                return surface;
            }
        }
        return null;
    }

    private static boolean isGoodFooting(Level level, BlockPos surface) {
        if (!level.m_46749_(surface)) {
            return false;
        }
        if (!level.m_46859_(surface)) {
            return false;
        }
        BlockPos feet = surface.m_7495_();
        if (!level.m_46749_(feet)) {
            return false;
        }
        if (!level.m_6425_(feet).m_76178_()) {
            return false;
        }
        return !level.m_8055_(feet).m_60812_((BlockGetter)level, feet).m_83281_();
    }

    private static boolean hasFenceNearby(Level level, BlockPos center, int r) {
        BlockPos p;
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                for (int dz = -r; dz <= r; ++dz) {
                    BlockPos p2 = center.m_142082_(dx, dy, dz);
                    if (!level.m_46749_(p2) || !EscapeWireEntityAI.isFenceBlock(level.m_8055_(p2))) continue;
                    return true;
                }
            }
        }
        for (int up = 1; up <= r + 2 && level.m_46749_(p = center.m_6630_(up)); ++up) {
            if (!EscapeWireEntityAI.isFenceBlock(level.m_8055_(p))) continue;
            return true;
        }
        return false;
    }

    private static boolean isFenceBlock(BlockState state) {
        return state.m_60734_() instanceof ElectricFenceWireBlock || state.m_60734_() instanceof ElectricFenceBaseBlock || state.m_60734_() instanceof ElectricFencePoleBlock;
    }
}

