/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.phys.Vec3;

public class WanderAroundWaterAI
extends Goal {
    protected final Animal entity;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private final double speed;
    protected int executionChance;
    private boolean mustUpdate;
    private final int walkradius;

    public WanderAroundWaterAI(Animal creatureIn, double speedIn, int chance, int walkradius) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.walkradius = walkradius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.mustUpdate && this.innerShouldStopExecuting()) {
            return false;
        }
        if (this.outerShouldExecute()) {
            block0: for (int i = 0; i < 100; ++i) {
                Vec3 vec = this.getWanderPosition();
                if (vec == null) continue;
                BlockPos from = new BlockPos(vec.f_82479_ + 0.0, vec.f_82480_ + 1.0, vec.f_82481_ + 0.0);
                BlockPos to = new BlockPos(vec.f_82479_ + 1.0, vec.f_82480_ + 1.0, vec.f_82481_ + 1.0);
                for (BlockPos pos : BlockPos.m_121940_((BlockPos)from, (BlockPos)to)) {
                    if (this.entity.f_19853_.m_8055_(pos).m_60795_()) continue;
                    continue block0;
                }
                this.xPosition = vec.f_82479_;
                this.yPosition = vec.f_82480_;
                this.zPosition = vec.f_82481_;
                this.mustUpdate = false;
                return true;
            }
        }
        return false;
    }

    protected boolean innerShouldStopExecuting() {
        return this.entity.m_21187_().nextInt(this.executionChance) != 0;
    }

    protected boolean outerShouldExecute() {
        return this.entity.m_21573_().m_26571_() && this.entity.m_5448_() == null && this.entity.f_19853_.m_46461_() && this.entity.m_20146_() > 0;
    }

    protected Vec3 getWanderPosition() {
        return DefaultRandomPos.m_148403_((PathfinderMob)this.entity, (int)this.walkradius, (int)this.walkradius);
    }

    public boolean m_8045_() {
        return !this.entity.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.entity.m_21573_().m_26519_(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int chance) {
        this.executionChance = chance;
    }
}

