/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai.metabolism;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.items.Food.FoodHelper;
import net.vit.jurassicreborn.common.util.GameRuleHandler;

public class EatFoodItemEntityAI
extends Goal {
    private static final double SEARCH_RADIUS = 16.0;
    private static final double SPEED = 1.0;
    protected final DinosaurEntity dinosaur;
    protected ItemEntity target;

    public EatFoodItemEntityAI(DinosaurEntity dinosaur) {
        this.dinosaur = dinosaur;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.dinosaur == null || !this.dinosaur.m_6084_() || this.dinosaur.isCarcass()) {
            return false;
        }
        if (this.dinosaur.m_5448_() != null) {
            return false;
        }
        Level level = this.dinosaur.f_19853_;
        if (level == null || !((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRuleHandler.DINO_METABOLISM)).m_46223_()) {
            return false;
        }
        if (!this.dinosaur.getMetabolism().isHungry()) {
            return false;
        }
        AABB box = this.dinosaur.m_142469_().m_82377_(16.0, 16.0, 16.0);
        List items = level.m_45976_(ItemEntity.class, box);
        double closestDist = Double.MAX_VALUE;
        ItemEntity closest = null;
        for (ItemEntity entity : items) {
            double distSqr;
            if (!entity.m_6084_()) continue;
            ItemStack stack = entity.m_32055_();
            Item item = stack.m_41720_();
            if (!FoodHelper.isEdible(this.dinosaur, this.dinosaur.getDinosaur().getDiet(), item) || !((distSqr = this.dinosaur.m_20280_((Entity)entity)) < closestDist)) continue;
            closestDist = distSqr;
            closest = entity;
        }
        if (closest != null) {
            this.target = closest;
            return true;
        }
        return false;
    }

    public void m_8056_() {
        if (this.target != null) {
            this.dinosaur.m_21573_().m_5624_((Entity)this.target, 1.0);
        }
    }

    public boolean m_8045_() {
        return this.dinosaur != null && this.dinosaur.m_6084_() && this.dinosaur.m_5448_() == null && this.target != null && this.target.m_6084_() && !this.dinosaur.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.dinosaur.m_21573_().m_26573_();
        this.target = null;
    }

    public void m_8037_() {
        if (this.target != null && this.target.m_6084_() && this.dinosaur.m_5448_() == null) {
            this.dinosaur.m_21573_().m_5624_((Entity)this.target, 1.0);
        }
    }
}

