/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.genetics;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.genetics.DNA;
import net.vit.jurassicreborn.common.genetics.DinoDNA;
import net.vit.jurassicreborn.common.genetics.PlantDNA;
import net.vit.jurassicreborn.common.genetics.StorageType;
import net.vit.jurassicreborn.common.genetics.StorageTypeRegistry;
import net.vit.jurassicreborn.common.items.genetics.StorageDiscModelData;
import net.vit.jurassicreborn.common.plants.PlantHandler;
import net.vit.jurassicreborn.common.util.api.SynthesizableItem;
import org.jetbrains.annotations.Nullable;

public class StorageDiscItem
extends Item
implements SynthesizableItem {
    public StorageDiscItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> toolTip, TooltipFlag pIsAdvanced) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            toolTip.add((Component)new TranslatableComponent("cage.empty").m_130940_(ChatFormatting.DARK_RED));
            return;
        }
        if (!tag.m_128441_("DNA")) {
            toolTip.add((Component)new TranslatableComponent("cage.empty").m_130940_(ChatFormatting.DARK_RED));
            return;
        }
        CompoundTag dna = tag.m_128469_("DNA");
        String storageId = dna.m_128461_("StorageId");
        StorageType type = StorageTypeRegistry.getStorageType(storageId);
        if (type != null) {
            type.load(tag);
            type.addInformation(stack, toolTip);
        }
        super.m_7373_(stack, pLevel, toolTip, pIsAdvanced);
    }

    @Override
    public boolean isSynthesizable(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        return tagCompound != null && tagCompound.m_128441_("DNA") && tagCompound.m_128469_("DNA").m_128451_("DNAQuality") == 100;
    }

    @Override
    public ItemStack getSynthesizedItem(ItemStack stack, Random random) {
        CompoundTag tag = stack.m_41783_();
        StorageType type = StorageTypeRegistry.getStorageType(tag.m_128469_("DNA").m_128461_("StorageId"));
        DNA dna = type.load(tag);
        ItemStack result = type.createItem();
        return result == null ? ItemStack.f_41583_ : result;
    }

    @Override
    public List<Pair<Float, ItemStack>> getChancedOutputs(ItemStack inputItem) {
        CompoundTag tag = inputItem.m_41783_();
        StorageType type = StorageTypeRegistry.getStorageType(tag.m_128469_("DNA").m_128461_("StorageId"));
        type.load(tag);
        ItemStack result = type.createItem();
        if (result.m_41619_()) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new Pair[]{new Pair((Object)Float.valueOf(100.0f), (Object)result)});
    }

    @Override
    public List<ItemStack> getJEIRecipeTypes() {
        ArrayList list = Lists.newArrayList();
        Dinosaur.DINOS.forEach(dino -> {
            DinoDNA dna = new DinoDNA((Dinosaur)dino, 100, "");
            ItemStack stack = new ItemStack((ItemLike)this);
            CompoundTag nbt = new CompoundTag();
            dna.writeToNBT(nbt);
            stack.m_41751_(nbt);
            StorageDiscItem.applyCustomModelData(stack);
            list.add(stack);
        });
        PlantHandler.getPlants().forEach(plant -> {
            PlantDNA dna = new PlantDNA(PlantHandler.getPlantId(plant), 100);
            ItemStack stack = new ItemStack((ItemLike)this);
            CompoundTag nbt = new CompoundTag();
            dna.writeToNBT(nbt);
            stack.m_41751_(nbt);
            StorageDiscItem.applyCustomModelData(stack);
            list.add(stack);
        });
        return list;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (!level.f_46443_) {
            StorageDiscItem.applyCustomModelData(stack);
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.f_19853_.f_46443_) {
            StorageDiscItem.applyCustomModelData(stack);
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public static void applyCustomModelData(ItemStack stack) {
        String plantId;
        if (stack.m_41619_() || !(stack.m_41720_() instanceof StorageDiscItem)) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("DNA")) {
            StorageDiscItem.clearCustomModelData(stack, tag);
            return;
        }
        CompoundTag dnaTag = tag.m_128469_("DNA");
        String storageId = dnaTag.m_128461_("StorageId");
        int modelData = 0;
        if ("DinoDNA".equals(storageId)) {
            Dinosaur dinosaur = Dinosaur.getDinosaurByName(dnaTag.m_128461_("Dinosaur"));
            modelData = StorageDiscModelData.resolveDinosaur(dinosaur);
        } else if ("PlantDNA".equals(storageId) && !(plantId = dnaTag.m_128461_("Plant")).isEmpty()) {
            ResourceLocation location = ResourceLocation.m_135820_((String)plantId);
            modelData = StorageDiscModelData.resolvePlant(location);
        }
        if (modelData > 0) {
            if (!tag.m_128441_("CustomModelData") || tag.m_128451_("CustomModelData") != modelData) {
                tag.m_128405_("CustomModelData", modelData);
                stack.m_41751_(tag);
            }
        } else {
            StorageDiscItem.clearCustomModelData(stack, tag);
        }
    }

    private static void clearCustomModelData(ItemStack stack, @Nullable CompoundTag tag) {
        if (tag == null) {
            return;
        }
        if (tag.m_128441_("CustomModelData")) {
            tag.m_128473_("CustomModelData");
            if (tag.m_128456_()) {
                stack.m_41751_(null);
            } else {
                stack.m_41751_(tag);
            }
        }
    }
}

