/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.items.misc;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.entities.item.BlueprintEntity;

public class BlueprintItem
extends Item {
    public static final String NBT_TYPE = "BlueprintType";

    public BlueprintItem(Item.Properties props) {
        super(props);
    }

    public static void setType(ItemStack stack, BlueprintEntity.Type type) {
        stack.m_41784_().m_128359_(NBT_TYPE, type.name());
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Direction face = ctx.m_43719_();
        if (!face.m_122434_().m_122479_()) {
            return InteractionResult.PASS;
        }
        Level level = ctx.m_43725_();
        ItemStack stack = ctx.m_43722_();
        BlueprintEntity.Type type = this.getStoredType(stack);
        BlockPos anchor = ctx.m_8083_().m_142300_(face);
        BlueprintEntity entity = new BlueprintEntity((EntityType<? extends BlueprintEntity>)((EntityType)ModEntities.BLUEPRINT.get()), level, anchor, face, type);
        if (!entity.m_7088_()) {
            return InteractionResult.FAIL;
        }
        if (!level.f_46443_) {
            level.m_7967_((Entity)entity);
            entity.m_7084_();
            Player player = ctx.m_43723_();
            if (player == null || !player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlueprintEntity.Type[] values = BlueprintEntity.Type.values();
        if (values.length == 0) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlueprintEntity.Type current = this.getStoredType(stack);
        int nextIndex = (current.ordinal() + 1) % values.length;
        BlueprintEntity.Type next = values[nextIndex];
        BlueprintItem.setType(stack, next);
        if (level.f_46443_) {
            player.m_5661_((Component)new TextComponent("Blueprint set to: " + BlueprintItem.displayName(next)), true);
        }
        player.m_6674_(hand);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag flag) {
        BlueprintEntity.Type type = this.getStoredType(stack);
        lines.add((Component)new TextComponent("Design: " + BlueprintItem.displayName(type)).m_130940_(ChatFormatting.AQUA));
        lines.add((Component)new TextComponent("Right-click in the air to change design").m_130940_(ChatFormatting.GRAY));
        lines.add((Component)new TextComponent("Note: Hitbox is 1x1 block!").m_130940_(ChatFormatting.GRAY));
    }

    private BlueprintEntity.Type getStoredType(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_TYPE)) {
            try {
                return BlueprintEntity.Type.valueOf(stack.m_41783_().m_128461_(NBT_TYPE));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        BlueprintEntity.Type fallback = BlueprintEntity.Type.TYRANNOSAURUS;
        BlueprintItem.setType(stack, fallback);
        return fallback;
    }

    private static String displayName(BlueprintEntity.Type type) {
        String lower = type.name().toLowerCase(Locale.ROOT).replace('_', ' ');
        return Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
    }
}

