/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.paleopad;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.feeder.FeederBlockEntity;
import net.vit.jurassicreborn.common.paleopad.App;
import net.vit.jurassicreborn.common.paleopad.AppHandler;
import net.vit.jurassicreborn.common.paleopad.FeederTrackerServerHelper;
import net.vit.jurassicreborn.common.util.networking.PlayerData;

public class FeederTrackerApp
extends App {
    public static final int LOW_FOOD_THRESHOLD = 10;
    private final List<TrackedFeeder> feeders = new ArrayList<TrackedFeeder>();

    @Override
    public String getName() {
        return "Feeder Tracker";
    }

    public List<TrackedFeeder> getFeeders() {
        return this.feeders;
    }

    public void registerFeeder(BlockPos pos, String name) {
        for (TrackedFeeder f : this.feeders) {
            if (!f.pos.equals((Object)pos)) continue;
            f.name = name;
            return;
        }
        this.feeders.add(new TrackedFeeder(pos, name));
    }

    public void unregisterFeeder(BlockPos pos) {
        this.feeders.removeIf(f -> f.pos.equals((Object)pos));
    }

    public static void addFeeder(Player player, BlockPos pos, Component name) {
        CompoundTag existing;
        FeederTrackerApp app = (FeederTrackerApp)AppHandler.INSTANCE.feederTracker;
        PlayerData data = PlayerData.get(player);
        if (!data.getOpenApps().contains(app) && (existing = data.getAppdata().get(app.getName())) != null) {
            app.readAppFromNBT(existing);
        }
        app.registerFeeder(pos, name.getString());
        CompoundTag out = new CompoundTag();
        app.writeAppToNBT(out);
        data.getAppdata().put(app.getName(), out);
        FeederTrackerServerHelper.sync(player, out);
    }

    public static void removeFeeder(Player player, BlockPos pos) {
        CompoundTag existing;
        FeederTrackerApp app = (FeederTrackerApp)AppHandler.INSTANCE.feederTracker;
        PlayerData data = PlayerData.get(player);
        if (!data.getOpenApps().contains(app) && (existing = data.getAppdata().get(app.getName())) != null) {
            app.readAppFromNBT(existing);
        }
        app.unregisterFeeder(pos);
        CompoundTag out = new CompoundTag();
        app.writeAppToNBT(out);
        data.getAppdata().put(app.getName(), out);
        FeederTrackerServerHelper.sync(player, out);
    }

    public int getFood(Level level, TrackedFeeder feeder) {
        BlockEntity blockEntity;
        if (level != null && (blockEntity = level.m_7702_(feeder.pos)) instanceof FeederBlockEntity) {
            FeederBlockEntity be = (FeederBlockEntity)blockEntity;
            int total = 0;
            for (int i = 0; i < be.m_6643_(); ++i) {
                total += be.m_8020_(i).m_41613_();
            }
            return total;
        }
        return 0;
    }

    @Override
    public void update() {
    }

    @Override
    public void writeToNBT(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (TrackedFeeder f : this.feeders) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", f.pos.m_123341_());
            tag.m_128405_("y", f.pos.m_123342_());
            tag.m_128405_("z", f.pos.m_123343_());
            tag.m_128359_("Name", f.name);
            list.add((Object)tag);
        }
        nbt.m_128365_("Feeders", (Tag)list);
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        this.feeders.clear();
        ListTag list = nbt.m_128437_("Feeders", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            BlockPos pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
            String name = tag.m_128461_("Name");
            this.feeders.add(new TrackedFeeder(pos, name));
        }
    }

    @Override
    public void init() {
    }

    public static class TrackedFeeder {
        public final BlockPos pos;
        public String name;

        public TrackedFeeder(BlockPos pos, String name) {
            this.pos = pos;
            this.name = name;
        }
    }
}

