/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.plants;

import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.vit.jurassicreborn.common.items.Food.FoodHelper;
import net.vit.jurassicreborn.common.plants.PlantHandler;

public class Plant
implements Comparable<Plant> {
    private final String name;
    private final Supplier<? extends Block> block;
    private final boolean shouldRegister;
    private final int healAmount;

    public Plant(String name, Supplier<? extends Block> block, int healAmount) {
        this(name, block, true, healAmount);
    }

    public Plant(String name, Supplier<? extends Block> block, boolean shouldRegister, int healAmount) {
        this.name = name;
        this.block = block;
        this.shouldRegister = shouldRegister;
        this.healAmount = healAmount;
    }

    public final String getName() {
        return this.name;
    }

    public Block getBlock() {
        return this.block.get();
    }

    public ResourceLocation getId() {
        return PlantHandler.getPlantId(this);
    }

    public final boolean shouldRegister() {
        return this.shouldRegister;
    }

    @Override
    public int compareTo(Plant plant) {
        return this.getName().compareTo(plant.getName());
    }

    public final int getHealAmount() {
        return this.healAmount;
    }

    public FoodHelper.FoodEffect[] getEffects() {
        return new FoodHelper.FoodEffect[0];
    }

    public boolean isPrehistoric() {
        return true;
    }

    public final boolean isTree() {
        return this.getBlock() instanceof SaplingBlock;
    }

    public String getFormattedName() {
        return this.getName().toLowerCase(Locale.ROOT).replace(' ', '_');
    }
}

