/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.worldgen;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.RebornConfig;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.worldgen.ModPlacements;

public final class BiomeModification {
    private static final TagKey<Biome> IS_END = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("minecraft", "is_end"));
    private static final TagKey<Biome> FORGE_MOUNTAIN = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("forge", "is_mountain"));

    private BiomeModification() {
    }

    @SubscribeEvent
    public static void onBiomeLoading(BiomeLoadingEvent event) {
        ResourceLocation name = event.getName();
        if (name == null) {
            return;
        }
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)name);
        Optional optional = ForgeRegistries.BIOMES.getHolder(key);
        if (optional.isEmpty()) {
            return;
        }
        Holder biome = (Holder)optional.get();
        if (biome.m_203656_(BiomeTags.f_207612_) || biome.m_203656_(IS_END)) {
            return;
        }
        event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.ICE_SHARD_ORE_PLACEMENT);
        event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.FAUNA_FOSSIL_PLACEMENT);
        event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.FLORA_FOSSIL_PLACEMENT);
        event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.NEST_FOSSIL_PLACEMENT);
        event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.AMBER_ORE_PLACEMENT);
        for (Holder<PlacedFeature> placement : ModPlacements.DINO_FOSSIL_PLACEMENTS) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, placement);
        }
        if (biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, ModPlacements.PEAT_DISK_PLACEMENT);
        }
        if (!biome.m_203656_(Tags.Biomes.IS_VOID)) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.PLACED_LARGE_PETRIFIED_TREE);
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacements.PLACED_SMALL_PETRIFIED_TREE);
        }
        if (RebornConfig.spawnCrabs && (biome.m_203656_(Tags.Biomes.IS_WET) || biome.m_203656_(BiomeTags.f_207603_))) {
            event.getSpawns().m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.CRAB.get(), 8, 2, 4));
        }
        if (RebornConfig.spawnSharks && biome.m_203656_(BiomeTags.f_207603_)) {
            event.getSpawns().m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SHARK.get(), 2, 1, 2));
        }
        if (RebornConfig.spawnGoats && (biome.m_203656_(BiomeTags.f_207606_) || biome.m_203656_(FORGE_MOUNTAIN))) {
            event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GOAT.get(), 6, 2, 4));
        }
    }
}

