/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.block;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.blocks.entities.HologramBlockEntity;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import org.jetbrains.annotations.NotNull;

public class HologramBlockEntityRender
implements BlockEntityRenderer<HologramBlockEntity> {
    public HologramBlockEntityRender(BlockEntityRendererProvider.Context ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(HologramBlockEntity blockEntity, float partialTick, PoseStack poseStack, @NotNull MultiBufferSource _ignoredGlobalBuffers, int packedLight, int packedOverlay) {
        DinosaurEntity entity = blockEntity.getEntity();
        if (entity == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)blockEntity.getRot()));
        EntityAnimation anim = blockEntity.getPoseAnimation();
        if (entity.getAnimation() != anim.get()) {
            entity.setAnimation(anim.get());
        }
        EntityRenderer er = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity);
        final ResourceLocation tex = er.m_5478_((Entity)entity);
        float TINT_R = 0.4f;
        float TINT_G = 0.69803923f;
        float TINT_B = 1.0f;
        float TINT_A = 0.5f;
        final MultiBufferSource.BufferSource privateBuffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        MultiBufferSource hologramBuffer = new MultiBufferSource(){

            @NotNull
            public VertexConsumer m_6299_(@NotNull RenderType requested) {
                if (requested == RenderType.m_110504_()) {
                    return privateBuffers.m_6299_(RenderType.m_110504_());
                }
                VertexConsumer base = privateBuffers.m_6299_(RenderType.m_110473_((ResourceLocation)tex));
                return new TintingVertexConsumer(base, 0.4f, 0.69803923f, 1.0f, 0.5f);
            }
        };
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int FULL_BRIGHT = LightTexture.m_109885_((int)15, (int)15);
        try {
            Minecraft.m_91087_().m_91290_().m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, hologramBuffer, FULL_BRIGHT);
            privateBuffers.m_109911_();
        }
        finally {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        poseStack.m_85849_();
    }

    private static class TintingVertexConsumer
    implements VertexConsumer {
        private final VertexConsumer delegate;
        private final float tr;
        private final float tg;
        private final float tb;
        private final float ta;

        TintingVertexConsumer(VertexConsumer delegate, float tr, float tg, float tb, float ta) {
            this.delegate = delegate;
            this.tr = tr;
            this.tg = tg;
            this.tb = tb;
            this.ta = ta;
        }

        public VertexConsumer m_6122_(int r, int g, int b, int a) {
            int nr = Math.min(255, Math.round((float)r * this.tr));
            int ng = Math.min(255, Math.round((float)g * this.tg));
            int nb = Math.min(255, Math.round((float)b * this.tb));
            int na = Math.min(255, Math.round((float)a * this.ta));
            return this.delegate.m_6122_(nr, ng, nb, na);
        }

        public VertexConsumer m_5483_(double x, double y, double z) {
            return this.delegate.m_5483_(x, y, z);
        }

        public VertexConsumer m_7421_(float u, float v) {
            return this.delegate.m_7421_(u, v);
        }

        public VertexConsumer m_7122_(int u, int v) {
            return this.delegate.m_7122_(u, v);
        }

        public VertexConsumer m_7120_(int u, int v) {
            return this.delegate.m_7120_(u, v);
        }

        public VertexConsumer m_5601_(float x, float y, float z) {
            return this.delegate.m_5601_(x, y, z);
        }

        public void m_5752_() {
            this.delegate.m_5752_();
        }

        public void m_7404_(int r, int g, int b, int a) {
        }

        public void m_141991_() {
        }
    }
}

