/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.block;

import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.vit.jurassicreborn.JurassicReborn;
import net.vit.jurassicreborn.common.blocks.entities.incubator.IncubatorBlock;
import net.vit.jurassicreborn.common.blocks.entities.incubator.IncubatorBlockEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.items.genetics.DinosaurEggItem;
import net.vit.jurassicreborn.common.legacy.tabula.TabulaModelHelper;
import net.vit.jurassicreborn.common.util.block.ModdedModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class IncubatorRenderer
implements BlockEntityRenderer<IncubatorBlockEntity>,
BlockEntityRendererProvider {
    private static final Map<Dinosaur, TabulaModel> EGG_MODELS;
    private static final TabulaModel DEFAULT_EGG_MODEL;
    private static final ResourceLocation DEFAULT_EGG_TEXTURE;
    private final GeoBlockRenderer<IncubatorBlockEntity> delegate = new GeoBlockRenderer<IncubatorBlockEntity>(new ModdedModel(JurassicReborn.resource("geo/incubator.geo.json"), JurassicReborn.resource("textures/block/incubator.png"), JurassicReborn.resource("animations/incubator.animation.json"))){};

    public IncubatorRenderer(BlockEntityRendererProvider.Context rendererProvider) {
    }

    public BlockEntityRenderer m_173570_(BlockEntityRendererProvider.Context pContext) {
        return new IncubatorRenderer(pContext);
    }

    public void render(IncubatorBlockEntity tile, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.renderEgg(tile.getItem(0), tile, poseStack, bufferSource, packedLight, 0.6f, 0.7f);
        this.renderEgg(tile.getItem(1), tile, poseStack, bufferSource, packedLight, 0.2f, 0.2f);
        this.renderEgg(tile.getItem(3), tile, poseStack, bufferSource, packedLight, 0.8f, 0.5f);
        this.renderEgg(tile.getItem(4), tile, poseStack, bufferSource, packedLight, 0.6f, 0.2f);
        this.renderEgg(tile.getItem(2), tile, poseStack, bufferSource, packedLight, 0.3f, 0.5f);
        this.delegate.m_6922_((BlockEntity)tile, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private static TabulaModel getEggModel(Dinosaur dino) {
        if (dino != null) {
            return EGG_MODELS.computeIfAbsent(dino, d -> {
                try {
                    return new TabulaModel(TabulaModelHelper.loadTabulaModel("/assets/jurassicreborn/models/entities/egg/" + d.getName().toLowerCase(Locale.ENGLISH)));
                }
                catch (Exception e) {
                    return DEFAULT_EGG_MODEL;
                }
            });
        }
        return DEFAULT_EGG_MODEL;
    }

    private static ResourceLocation getEggTexture(Dinosaur dino) {
        if (dino != null) {
            ResourceLocation texture = new ResourceLocation("jurassicreborn", "textures/entities/egg/" + dino.getName().toLowerCase(Locale.ENGLISH) + ".png");
            if (Minecraft.m_91087_().m_91098_().m_213713_(texture).isPresent()) {
                return texture;
            }
        }
        return DEFAULT_EGG_TEXTURE;
    }

    private void renderEgg(ItemStack stack, IncubatorBlockEntity tile, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float xMod, float zMod) {
        if (stack.m_41619_()) {
            return;
        }
        poseStack.m_85836_();
        Direction facing = (Direction)tile.m_58900_().m_61143_((Property)IncubatorBlock.FACING);
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-facing.m_122435_()));
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        poseStack.m_252880_(xMod, 0.65f, zMod);
        poseStack.m_252880_(0.0f, 1.45f, 0.0f);
        poseStack.m_85841_(-0.5f, -0.5f, -0.5f);
        Item item = stack.m_41720_();
        if (item instanceof DinosaurEggItem) {
            DinosaurEggItem eggItem = (DinosaurEggItem)item;
            Dinosaur dino = eggItem.getDino();
            TabulaModel model = IncubatorRenderer.getEggModel(dino);
            ResourceLocation texture = IncubatorRenderer.getEggTexture(dino);
            VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
            model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }

    static {
        ResourceLocation texture;
        TabulaModel model;
        EGG_MODELS = new HashMap<Dinosaur, TabulaModel>();
        try {
            model = new TabulaModel(TabulaModelHelper.loadTabulaModel("/assets/jurassicreborn/models/entities/egg/tyrannosaurus"));
            texture = new ResourceLocation("jurassicreborn", "textures/entities/egg/tyrannosaurus.png");
        }
        catch (Exception e) {
            model = null;
            texture = null;
            e.printStackTrace();
        }
        DEFAULT_EGG_MODEL = model;
        DEFAULT_EGG_TEXTURE = texture;
    }
}

