/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.render.entity.animation.entity;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.vit.jurassicreborn.client.model.AnimatableModel;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimator;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.BaryonyxEntity;

@OnlyIn(value=Dist.CLIENT)
public class BaryonyxAnimator
extends EntityAnimator<BaryonyxEntity> {
    private static float clamp(float v, float lo, float hi) {
        return v < lo ? lo : (v > hi ? hi : v);
    }

    private static float rad(float d) {
        return (float)Math.toRadians(d);
    }

    @Override
    protected void performAnimations(AnimatableModel model, BaryonyxEntity entity, float f, float f1, float ticks, float yaw, float pitch, float scale) {
        AdvancedModelBox Body1 = model.getCube("Body 1");
        AdvancedModelBox Body2 = model.getCube("Body 2");
        AdvancedModelBox Body3 = model.getCube("Body 3");
        AdvancedModelBox Throat1 = model.getCube("Throat 1");
        AdvancedModelBox Neck1 = model.getCube("Neck1");
        AdvancedModelBox Neck2 = model.getCube("Neck2");
        AdvancedModelBox Neck3 = model.getCube("Neck3");
        AdvancedModelBox Neck4 = model.getCube("Neck4");
        AdvancedModelBox Neck5 = model.getCube("Neck5");
        AdvancedModelBox Neck6 = model.getCube("Neck6");
        AdvancedModelBox Head = model.getCube("Head");
        AdvancedModelBox LowerJawmain = model.getCube("Lower Jaw main");
        AdvancedModelBox[] bodyChain = new AdvancedModelBox[]{Body1, Body2, Body3};
        AdvancedModelBox[] neckChain = new AdvancedModelBox[]{Neck1, Neck2, Neck3, Neck4, Neck5, Neck6, Head};
        model.chainWave(bodyChain, 0.1f, 0.05f, 2.0, ticks, 0.35f);
        model.chainWave(neckChain, 0.12f, 0.04f, -3.0, ticks, 0.3f);
        if (!entity.isCarcass()) {
            if (Throat1 != null) {
                Throat1.rotateAngleX += (float)Math.sin(ticks * 0.12f) * 0.04f;
            }
            if (LowerJawmain != null) {
                LowerJawmain.rotateAngleX += (float)Math.sin(ticks * 0.1f + 0.6f) * 0.03f;
            }
            float lookYaw = BaryonyxAnimator.clamp(BaryonyxAnimator.rad(yaw), BaryonyxAnimator.rad(-45.0f), BaryonyxAnimator.rad(45.0f));
            float lookPitch = BaryonyxAnimator.clamp(BaryonyxAnimator.rad(pitch), BaryonyxAnimator.rad(-25.0f), BaryonyxAnimator.rad(25.0f));
            float[] w = new float[]{0.08f, 0.1f, 0.13f, 0.17f, 0.2f, 0.2f, 0.12f};
            for (int i = 0; i < neckChain.length && i < w.length; ++i) {
                AdvancedModelBox p = neckChain[i];
                if (p == null) continue;
                p.rotateAngleY += lookYaw * w[i];
                p.rotateAngleX += lookPitch * w[i];
            }
        }
    }
}

