/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.entities.EntityUtils.FoodType;

public class FieldGuideScreen
extends Screen {
    private final int imageWidth = 256;
    private final int imageHeight = 192;
    private int currentIndex = 0;
    private List<Dinosaur> dinosaurs;
    private static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("jurassicreborn", "textures/field_guide/background.png");
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("jurassicreborn", "textures/journal/widgets.png");
    private final Map<Dinosaur, DinosaurEntity> skeletonCache = new HashMap<Dinosaur, DinosaurEntity>();

    public FieldGuideScreen() {
        super((Component)Component.m_237113_((String)"InGen Field Guide"));
        this.dinosaurs = new ArrayList<Dinosaur>((Collection<Dinosaur>)Dinosaur.DINOSAUR_IDS.keySet());
        this.dinosaurs.sort((a, b) -> a.getName().compareToIgnoreCase(b.getName()));
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.leftPos();
        int y = this.topPos();
        this.m_142416_((GuiEventListener)new ArrowButton(x - 3, y + 180, false, btn -> this.switchEntry(-1)));
        this.m_142416_((GuiEventListener)new ArrowButton(x + 235, y + 180, true, btn -> this.switchEntry(1)));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BOOK_TEXTURE);
        guiGraphics.m_280218_(BOOK_TEXTURE, this.leftPos(), this.topPos(), 0, 0, 256, 192);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.currentIndex >= 0 && this.currentIndex < this.dinosaurs.size()) {
            FoodType type;
            Dinosaur dino = this.dinosaurs.get(this.currentIndex);
            int xLeft = this.leftPos() + 24;
            int y = this.topPos() + 20;
            int wrapWidth = 90;
            List nameLines = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)(this.currentIndex + 1 + ". " + dino.getName())), wrapWidth);
            for (int i = 0; i < nameLines.size(); ++i) {
                guiGraphics.m_280649_(this.f_96547_, (FormattedCharSequence)nameLines.get(i), xLeft, y + i * 10, 0x3E3E3E, false);
            }
            guiGraphics.m_280056_(this.f_96547_, "Scientific Name:", xLeft, y + 30, 0x3E3E3E, false);
            List sciLines = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)dino.getScientificName()), wrapWidth);
            for (int i = 0; i < sciLines.size(); ++i) {
                guiGraphics.m_280649_(this.f_96547_, (FormattedCharSequence)sciLines.get(i), xLeft + 5, y + 40 + i * 10, 0x555555, false);
            }
            int offsetY = y + 15 + sciLines.size() * 10 + 5;
            List periodLines = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)("Period: " + dino.getPeriod())), wrapWidth);
            for (int i = 0; i < periodLines.size(); ++i) {
                guiGraphics.m_280649_(this.f_96547_, (FormattedCharSequence)periodLines.get(i), xLeft, offsetY + 30 + i * 10, 0x3E3E3E, false);
            }
            List familyLines = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)("Family: " + dino.getFamily())), wrapWidth);
            for (int i = 0; i < familyLines.size(); ++i) {
                guiGraphics.m_280649_(this.f_96547_, (FormattedCharSequence)familyLines.get(i), xLeft, offsetY + 50 + i * 10, 0x3E3E3E, false);
            }
            List locationLines = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)("Location: " + dino.getLocation())), wrapWidth);
            for (int i = 0; i < locationLines.size(); ++i) {
                guiGraphics.m_280649_(this.f_96547_, (FormattedCharSequence)locationLines.get(i), xLeft, offsetY + 80 + i * 10, 0x3E3E3E, false);
            }
            Object diet = "Unknown";
            if (dino.getDiet() != null && !dino.getDiet().getModules().isEmpty() && (type = dino.getDiet().getModules().get(0).getFoodType()) != null) {
                diet = type.name().charAt(0) + type.name().substring(1).toLowerCase();
            }
            guiGraphics.m_280056_(this.f_96547_, "Diet: " + (String)diet, xLeft, offsetY + 100, 0x3E3E3E, false);
            int skeletonX = this.leftPos() + 256 - 72;
            int skeletonY = this.topPos() + 192 - 55;
            int skeletonScale = 15;
            if (dino == DinosaurHandler.CAMARASAURUS || dino == DinosaurHandler.NIGERSAURUS || dino == DinosaurHandler.MAMENCHISAURUS || dino == DinosaurHandler.BRACHIOSAURUS || dino == DinosaurHandler.ANKYLODOCUS || dino == DinosaurHandler.DREADNOUGHTUS || dino == DinosaurHandler.GIGANOTOSAURUS || dino == DinosaurHandler.SPINOSAURUS || dino == DinosaurHandler.STEGOSAURUS || dino == DinosaurHandler.RAPHUSREX || dino == DinosaurHandler.APATOSAURUS || dino == DinosaurHandler.TYLOSAURUS || dino == DinosaurHandler.THERIZINOSAURUS || dino == DinosaurHandler.LAMBEOSAURUS || dino == DinosaurHandler.EDMONTOSAURUS || dino == DinosaurHandler.CORYTHOSAURUS || dino == DinosaurHandler.INDOMINUS || dino == DinosaurHandler.DIPLODOCUS) {
                skeletonScale = 5;
            }
            if (dino == DinosaurHandler.MOSASAURUS) {
                skeletonScale = 3;
            }
            if (dino == DinosaurHandler.ALLIGATOR_GAR || dino == DinosaurHandler.ALVAREZSAURUS || dino == DinosaurHandler.ASTEROCERAS || dino == DinosaurHandler.MEGALODON || dino == DinosaurHandler.BEELZEBUFO || dino == DinosaurHandler.DIMORPHODON || dino == DinosaurHandler.DODO || dino == DinosaurHandler.LEAELLYNASAURA || dino == DinosaurHandler.MEGAPIRANHA || dino == DinosaurHandler.PROTOCERATOPS || dino == DinosaurHandler.SEGISAURUS || dino == DinosaurHandler.TROODON || dino == DinosaurHandler.HYPSILOPHODON) {
                skeletonScale = 30;
            }
            if (dino == DinosaurHandler.DIPLOCAULUS || dino == DinosaurHandler.ALVAREZSAURUS || dino == DinosaurHandler.MICROCERATUS || dino == DinosaurHandler.MICRORAPTOR || dino == DinosaurHandler.OTHNIELIA || dino == DinosaurHandler.OVIRAPTOR) {
                skeletonScale = 30;
            }
            if (dino == DinosaurHandler.COMPSOGNATHUS) {
                skeletonScale = 70;
            }
            if (dino == DinosaurHandler.ALLOSAURUS || dino == DinosaurHandler.CARNOTAURUS || dino == DinosaurHandler.CERATOSAURUS || dino == DinosaurHandler.DEINOTHERIUM || dino == DinosaurHandler.DUNKLEOSTEUS || dino == DinosaurHandler.TYRANNOSAURUS || dino == DinosaurHandler.MAMMOTH || dino == DinosaurHandler.PARASAUROLOPHUS || dino == DinosaurHandler.QUETZAL || dino == DinosaurHandler.SUCHOMIMUS || dino == DinosaurHandler.PARACERATHERIUM) {
                skeletonScale = 10;
            }
            if (dino == DinosaurHandler.ANKYLOSAURUS || dino == DinosaurHandler.CARCHARODONTOSAURUS) {
                skeletonScale = 8;
            }
            if (dino == DinosaurHandler.SPINORAPTOR) {
                skeletonScale = 12;
            }
            this.renderSkeletonModel(guiGraphics.m_280168_(), skeletonX, skeletonY, skeletonScale, dino);
        }
    }

    private void renderSkeletonModel(PoseStack stack, int x, int y, int scale, Dinosaur dino) {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher dispatcher = mc.m_91290_();
        RegistryObject<? extends EntityType<? extends DinosaurEntity>> reg = DinosaurEntity.CLASS_TYPE_LIST.get(dino.getDinosaurClass());
        if (reg == null) {
            return;
        }
        DinosaurEntity entity = this.skeletonCache.computeIfAbsent(dino, key -> {
            DinosaurEntity e = (DinosaurEntity)((EntityType)reg.get()).m_20615_((Level)mc.f_91073_);
            if (e != null) {
                e.setAge(dino.getMaximumAge());
                e.setSkeleton(true);
                e.setSkeletonVariant((byte)0);
                e.setIsFossile(true);
                boolean hasMaleSkeleton = !dino.isHybrid;
                e.setIsFossile(hasMaleSkeleton);
                e.setupDisplay(hasMaleSkeleton);
                e.setAnimation(EntityAnimation.IDLE.get());
                e.m_21557_(true);
            }
            return e;
        });
        if (entity == null) {
            return;
        }
        entity.setAnimationTick(0);
        stack.m_85836_();
        stack.m_252880_((float)x, (float)y, 100.0f);
        stack.m_85841_((float)(-scale), (float)scale, (float)scale);
        stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(-135.0f));
        stack.m_252781_(Axis.f_252529_.m_252977_(-10.0f));
        dispatcher.m_114468_(false);
        RenderSystem.runAsFancy(() -> dispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, stack, (MultiBufferSource)mc.m_91269_().m_110104_(), 0xF000F0));
        dispatcher.m_114468_(true);
        mc.m_91269_().m_110104_().m_109911_();
        stack.m_85849_();
    }

    private void switchEntry(int delta) {
        this.currentIndex = (this.currentIndex + delta + this.dinosaurs.size()) % this.dinosaurs.size();
    }

    private int leftPos() {
        return (this.f_96543_ - 256) / 2;
    }

    private int topPos() {
        return (this.f_96544_ - 192) / 2;
    }

    private class ArrowButton
    extends Button {
        private final boolean isForward;

        public ArrowButton(int x, int y, boolean isForward, Button.OnPress onPress) {
            super(x, y, 23, 13, (Component)Component.m_237119_(), onPress, f_252438_);
            this.isForward = isForward;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.f_93624_) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGETS_TEXTURE);
                int u = this.f_93622_ ? 23 : 0;
                int v = this.isForward ? 194 : 207;
                guiGraphics.m_280218_(WIDGETS_TEXTURE, this.m_252754_(), this.m_252907_(), u, v, this.f_93618_, this.f_93619_);
            }
        }
    }
}

