/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.vit.jurassicreborn.client.screens.paleopad.GuiApp;
import net.vit.jurassicreborn.client.screens.paleopad.GuiAppRegistry;
import net.vit.jurassicreborn.common.paleopad.App;
import net.vit.jurassicreborn.common.paleopad.AppHandler;
import net.vit.jurassicreborn.common.util.networking.PlayerData;

public class PaleoPadScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/paleo_pad.png");
    private final App initialApp;
    private GuiApp focus;

    public PaleoPadScreen() {
        this(null);
    }

    public PaleoPadScreen(App initialApp) {
        super((Component)Component.m_237113_((String)"PaleoPad"));
        this.initialApp = initialApp;
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.focus != null) {
            this.focus.update();
            if (this.focus.doesRequestShutdown()) {
                this.focus = null;
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.initialApp != null && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.focus = GuiAppRegistry.getGui(this.initialApp);
            this.focus.init();
            PlayerData.get((Player)this.f_96541_.f_91074_).openApp(this.initialApp);
        }
    }

    public void m_7861_() {
        if (this.focus != null && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            PlayerData.get((Player)this.f_96541_.f_91074_).closeApp(this.focus.getApp());
        }
    }

    public void drawScaledRect(GuiGraphics guiGraphics, int x, int y, int w, int h, float scale, int color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280509_(0, 0, w, h, color);
        poseStack.m_85849_();
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        int width = this.f_96543_;
        int height = this.f_96544_;
        Minecraft mc = Minecraft.m_91087_();
        if (this.focus == null) {
            List<App> apps = AppHandler.INSTANCE.getApps();
            for (int i = 0; i < apps.size(); ++i) {
                int x = i % 4 * 55 + width / 2 - 110;
                int y = i / 4 * 38 + 70;
                if (!(mouseX > (double)x) || !(mouseY > (double)y) || !(mouseX < (double)(x + 32)) || !(mouseY < (double)(y + 32))) continue;
                App app = apps.get(i);
                this.focus = GuiAppRegistry.getGui(app);
                this.focus.init();
                PlayerData.get((Player)mc.f_91074_).openApp(app);
                break;
            }
        } else {
            this.focus.mouseClicked((int)mouseX, (int)mouseY, this);
            int adjX = (int)(mouseX - (double)(width / 2) + 115.0);
            int adjY = (int)(mouseY - 65.0);
            if (adjX > 97 && adjY > 153 && adjX < 131 && adjY < 157) {
                this.focus.requestShutdown();
                this.focus = null;
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280163_(TEXTURE, this.f_96543_ / 2 - 128, 40, 0.0f, 0.0f, 256, 256, 256, 256);
        List<App> apps = AppHandler.INSTANCE.getApps();
        double worldTime = mc.f_91073_ != null ? (double)((mc.f_91073_.m_46468_() + 6000L) % 24000L) : 0.0;
        int hours = (int)(worldTime / 1000.0) % 24;
        int minutes = (int)((worldTime / 1000.0 - (double)hours) * 60.0);
        String hoursStr = String.format("%02d", hours);
        String minutesStr = String.format("%02d", minutes);
        this.drawCenteredScaledText(guiGraphics, hoursStr + ":" + minutesStr, this.f_96543_ / 2, 50, 1.0f, 0xFFFFFF);
        if (this.focus == null) {
            for (int i = 0; i < apps.size(); ++i) {
                int x = i % 4 * 50 + 5;
                int y = i / 4 * 42;
                App app = apps.get(i);
                GuiApp gui = GuiAppRegistry.getGui(app);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)gui.getTexture(this));
                guiGraphics.m_280163_(gui.getTexture(this), x + 5 + this.f_96543_ / 2 - 115, y + 5 + 65, 0.0f, 0.0f, 32, 32, 32, 32);
                this.drawCenteredScaledText(guiGraphics, app.getName(), x + 22 + this.f_96543_ / 2 - 115, y + 39 + 65, 0.7f, 0xFFFFFF);
            }
            this.drawScaledText(guiGraphics, Component.m_237115_((String)"paleopad.os.name").getString(), this.f_96543_ / 2 - 115 + 2, 55, 1.0f, 0xFFFFFF);
        } else if (this.focus.getApp().getName() != null) {
            this.drawScaledText(guiGraphics, this.focus.getApp().getName(), this.f_96543_ / 2 - 115 + 2, 55, 1.0f, 0xFFFFFF);
            this.focus.render(guiGraphics, mouseX, mouseY, this, partialTicks);
        } else {
            this.focus = null;
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void drawCenteredScaledText(GuiGraphics guiGraphics, String text, int x, int y, float scale, int color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        int width = Minecraft.m_91087_().f_91062_.m_92895_(text);
        int drawX = Math.round((float)(-width) / 2.0f);
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, text, drawX, 0, color, false);
        poseStack.m_85849_();
    }

    public void drawScaledText(GuiGraphics guiGraphics, String text, int x, int y, float scale, int color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, text, 0, 0, color, false);
        poseStack.m_85849_();
    }

    public boolean m_7043_() {
        return false;
    }
}

