/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.screens;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;
import net.vit.jurassicreborn.common.network.Network;
import net.vit.jurassicreborn.common.network.PaddockSignPlacePacket;

public class SelectDinosaurScreen
extends Screen {
    private final BlockPos signPos;
    private final Direction face;
    private final InteractionHand hand;
    private List<Integer> dinoIds;
    private int page = 0;
    private static final int COLUMNS = 4;
    private static final int ROWS = 5;
    private static final int PER_PAGE = 20;

    public SelectDinosaurScreen(BlockPos pos, Direction face, InteractionHand hand) {
        super((Component)Component.m_237113_((String)"Select Dinosaur"));
        this.signPos = pos;
        this.face = face;
        this.hand = hand;
    }

    protected void m_7856_() {
        DinosaurHandler.doDinosInit();
        this.dinoIds = DinosaurHandler.getRegisteredIds();
        this.page = 0;
        this.buildPage();
    }

    private void buildPage() {
        this.m_169413_();
        int gridWidth = 320;
        int gridHeight = 100;
        int startX = (this.f_96543_ - gridWidth) / 2;
        int startY = (this.f_96544_ - gridHeight) / 2;
        int startIndex = this.page * 20;
        int endIndex = Math.min(startIndex + 20, this.dinoIds.size());
        int idx = startIndex;
        for (int row = 0; row < 5 && idx < endIndex; ++row) {
            for (int col = 0; col < 4 && idx < endIndex; ++idx, ++col) {
                int id = this.dinoIds.get(idx);
                Dinosaur d = DinosaurHandler.getById(id);
                String name = d == Dinosaur.EMPTY ? "None" : d.getName();
                int x = startX + col * 80;
                int y = startY + row * 20;
                int selectedId = id;
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)name), btn -> {
                    Network.sendToServer(new PaddockSignPlacePacket(this.signPos, this.face, this.hand, selectedId));
                    this.f_96541_.m_91152_(null);
                }).m_252987_(x, y, 80, 20).m_253136_());
            }
        }
        int totalPages = (this.dinoIds.size() + 20 - 1) / 20;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), btn -> {
            this.page = (this.page - 1 + totalPages) % totalPages;
            this.buildPage();
        }).m_252987_(startX, startY + gridHeight + 5, 20, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), btn -> {
            this.page = (this.page + 1) % totalPages;
            this.buildPage();
        }).m_252987_(startX + gridWidth - 20, startY + gridHeight + 5, 20, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float ptt) {
        this.m_280273_(guiGraphics);
        int gridHeight = 100;
        int startY = (this.f_96544_ - gridHeight) / 2;
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, startY - 20, 0xFFFFFF);
        int totalPages = (this.dinoIds.size() + 20 - 1) / 20;
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)(this.page + 1 + "/" + totalPages)), this.f_96543_ / 2, startY + gridHeight + 10, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, ptt);
    }

    public boolean m_6913_() {
        return true;
    }
}

