/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.screens.paleopad;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.vit.jurassicreborn.client.screens.PaleoPadScreen;
import net.vit.jurassicreborn.client.screens.paleopad.GuiApp;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.paleopad.App;

public class MinimapGuiApp
extends GuiApp {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/apps/minimap.png");
    private final Map<BlockPos, Integer> heights = new HashMap<BlockPos, Integer>();
    private int scroll;

    public MinimapGuiApp(App app) {
        super(app);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, Screen screen, float partialTicks) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Level world = player.m_9236_();
        if (world == null) {
            return;
        }
        int left = screen.f_96543_ / 2 - 115;
        int top = 65;
        String loc = "Location: " + Mth.m_14107_((double)player.m_20185_()) + " " + Mth.m_14107_((double)player.m_20186_()) + " " + Mth.m_14107_((double)player.m_20189_());
        UUID playerUUID = player.m_20148_();
        ArrayList<DinosaurEntity> tracked = new ArrayList<DinosaurEntity>();
        for (Entity entity : world.m_45933_((Entity)player, player.m_20191_().m_82400_(256.0))) {
            DinosaurEntity dino;
            if (!(entity instanceof DinosaurEntity) || !(dino = (DinosaurEntity)entity).getTrackers().contains(playerUUID)) continue;
            tracked.add(dino);
        }
        int playerX = Mth.m_14107_((double)player.m_20185_());
        int playerZ = Mth.m_14107_((double)player.m_20189_());
        int playerChunkX = playerX >> 4;
        int playerChunkZ = playerZ >> 4;
        int mapStartX = left + 80;
        int mapStartZ = top + 20;
        int mapSize = 128;
        int chunkX = playerChunkX - 4;
        int renderChunkX = 0;
        while (chunkX < playerChunkX + 4) {
            int chunkZ = playerChunkZ - 4;
            int renderChunkZ = 0;
            while (chunkZ < playerChunkZ + 4) {
                LevelChunk chunk = world.m_6325_(chunkX, chunkZ);
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        int blockX = x + chunkX * 16;
                        int blockZ = z + chunkZ * 16;
                        BlockPos pos = this.getHeight(world, blockX, blockZ);
                        int blockY = pos.m_123342_();
                        BlockState blockState = world.m_8055_(pos);
                        MapColor mapColor = blockState.m_284242_((BlockGetter)world, pos);
                        if (mapColor == null) {
                            mapColor = MapColor.f_283808_;
                        }
                        int rgb = mapColor.f_283871_;
                        int r = rgb >> 16 & 0xFF;
                        int g = rgb >> 8 & 0xFF;
                        int b = rgb & 0xFF;
                        int lightnessOffset = 0;
                        lightnessOffset -= this.getHeight(world, blockX - 1, blockZ).m_123342_() > blockY ? 10 : 0;
                        lightnessOffset -= this.getHeight(world, blockX, blockZ - 1).m_123342_() > blockY ? 10 : 0;
                        lightnessOffset -= this.getHeight(world, blockX + 1, blockZ).m_123342_() > blockY ? 10 : 0;
                        r = Mth.m_14045_((int)(r + (lightnessOffset -= this.getHeight(world, blockX, blockZ + 1).m_123342_() > blockY ? 10 : 0)), (int)0, (int)255);
                        g = Mth.m_14045_((int)(g + lightnessOffset), (int)0, (int)255);
                        b = Mth.m_14045_((int)(b + lightnessOffset), (int)0, (int)255);
                        rgb = r << 16 | g << 8 | b;
                        int argb = 0xFF000000 | rgb;
                        int px = mapStartX + renderChunkX * 16 + x;
                        int pz = mapStartZ + renderChunkZ * 16 + z;
                        ((PaleoPadScreen)screen).drawScaledRect(guiGraphics, px, pz, 1, 1, 1.0f, argb);
                    }
                }
                ++chunkZ;
                ++renderChunkZ;
            }
            ++chunkX;
            ++renderChunkX;
        }
        int playerPx = mapStartX + playerX - (playerChunkX - 4) * 16;
        int playerPz = mapStartZ + playerZ - (playerChunkZ - 4) * 16;
        if (playerPx >= mapStartX && playerPx < mapStartX + mapSize && playerPz >= mapStartZ && playerPz < mapStartZ + mapSize) {
            ((PaleoPadScreen)screen).drawScaledRect(guiGraphics, playerPx - 1, playerPz - 1, 3, 3, 1.0f, -1);
            ((PaleoPadScreen)screen).drawScaledText(guiGraphics, "YOU", playerPx + 2, playerPz - 5, 0.6f, 0xFFFFFF);
        }
        for (Entity entity : world.m_45933_((Entity)player, player.m_20191_().m_82400_(256.0))) {
            DinosaurEntity dino;
            if (!(entity instanceof DinosaurEntity) || !(dino = (DinosaurEntity)entity).getTrackers().contains(playerUUID)) continue;
            int dinoX = Mth.m_14107_((double)dino.m_20185_());
            int dinoZ = Mth.m_14107_((double)dino.m_20189_());
            int px = mapStartX + dinoX - (playerChunkX - 4) * 16;
            int pz = mapStartZ + dinoZ - (playerChunkZ - 4) * 16;
            if (px < mapStartX || px >= mapStartX + mapSize || pz < mapStartZ || pz >= mapStartZ + mapSize) continue;
            int color = 0xFF000000 | dino.m_20148_().hashCode() & 0xFFFFFF;
            ((PaleoPadScreen)screen).drawScaledRect(guiGraphics, px - 1, pz - 1, 3, 3, 1.0f, color);
            String name = dino.m_5446_().getString();
            ((PaleoPadScreen)screen).drawScaledText(guiGraphics, name, px + 3, pz - 5, 0.6f, color);
        }
        ((PaleoPadScreen)screen).drawScaledText(guiGraphics, loc, left + 10, top + 10, 1.0f, 0xFFFFFF);
        int visible = 4;
        int itemHeight = 11;
        int trackedY = top + 30;
        for (int i = 0; i < visible && this.scroll + i < tracked.size(); ++i) {
            DinosaurEntity dino = (DinosaurEntity)tracked.get(this.scroll + i);
            String label = dino.m_5446_().getString() + " at " + dino.m_20183_().m_123344_();
            ((PaleoPadScreen)screen).drawScaledText(guiGraphics, label, left + 10, trackedY, 0.85f, 10551104);
            trackedY += itemHeight;
        }
        int trackX = left + 74;
        int trackY = top + 30;
        int trackHeight = visible * itemHeight;
        ((PaleoPadScreen)screen).drawScaledRect(guiGraphics, trackX, trackY, 4, trackHeight, 1.0f, -13619152);
        int total = tracked.size();
        if (total > visible) {
            int knobHeight = Math.max(8, trackHeight * visible / total);
            int maxScroll = total - visible;
            int knobY = trackY + (trackHeight - knobHeight) * this.scroll / maxScroll;
            ((PaleoPadScreen)screen).drawScaledRect(guiGraphics, trackX, knobY, 4, knobHeight, 1.0f, -8355712);
        }
    }

    private BlockPos getHeight(Level world, int x, int z) {
        BlockPos posKey = new BlockPos(x, 0, z);
        if (this.heights.containsKey(posKey)) {
            return new BlockPos(x, this.heights.get(posKey).intValue(), z);
        }
        int y = world.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z) - 1;
        BlockPos pos = new BlockPos(x, y, z);
        while ((world.m_8055_(pos).m_60795_() || world.m_8055_(pos).m_60819_().m_192917_((Fluid)Fluids.f_76193_)) && y > world.m_141937_()) {
            pos = new BlockPos(x, --y, z);
        }
        BlockPos up = pos.m_7494_();
        if (!world.m_8055_(up).m_60795_()) {
            pos = up;
        }
        this.heights.put(posKey, pos.m_123342_());
        return pos;
    }

    @Override
    public void actionPerformed(Button button) {
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, Screen screen) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Level world = player.m_9236_();
        if (world == null) {
            return;
        }
        int left = screen.f_96543_ / 2 - 115;
        int top = 65;
        int visible = 4;
        int itemHeight = 11;
        int trackX = left + 74;
        int trackY = top + 30;
        int trackHeight = visible * itemHeight;
        UUID playerUUID = player.m_20148_();
        ArrayList<DinosaurEntity> tracked = new ArrayList<DinosaurEntity>();
        for (Entity entity : world.m_45933_((Entity)player, player.m_20191_().m_82400_(256.0))) {
            DinosaurEntity dino;
            if (!(entity instanceof DinosaurEntity) || !(dino = (DinosaurEntity)entity).getTrackers().contains(playerUUID)) continue;
            tracked.add(dino);
        }
        int total = tracked.size();
        if (mouseX >= (double)trackX && mouseX <= (double)(trackX + 4) && mouseY >= (double)trackY && mouseY <= (double)(trackY + trackHeight) && total > visible) {
            int knobHeight = Math.max(8, trackHeight * visible / total);
            int maxScroll = total - visible;
            int rel = (int)mouseY - trackY - knobHeight / 2;
            this.scroll = Mth.m_14045_((int)((int)((double)rel / (double)(trackHeight - knobHeight) * (double)maxScroll)), (int)0, (int)maxScroll);
        }
    }

    @Override
    public void init() {
        this.heights.clear();
        this.scroll = 0;
    }

    @Override
    public ResourceLocation getTexture(Screen screen) {
        return TEXTURE;
    }
}

