/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.client.screens.paleopad;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.DinosaurStatus;
import net.vit.jurassicreborn.common.util.LangUtil;

public class PaleoPadViewDinosaurScreen
extends Screen {
    private static final int SIZE_X = 256;
    private static final int SIZE_Y = 192;
    private static final int TOTAL_PAGES = 2;
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("jurassicreborn", "textures/gui/paleo_pad/paleo_pad.png");
    private static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("jurassicreborn", "textures/field_guide/widgets.png");
    private static final Map<DinosaurStatus, ResourceLocation> STATUS_TEXTURES = new HashMap<DinosaurStatus, ResourceLocation>();
    private final DinosaurEntity entity;
    private final DinosaurEntity.FieldGuideInfo guideInfo;
    private int page = 0;
    private Button nextPage;
    private Button previousPage;

    public PaleoPadViewDinosaurScreen(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo guideInfo) {
        super((Component)Component.m_237113_((String)"PaleoPad Dinosaur View"));
        this.entity = entity;
        this.guideInfo = guideInfo;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - 256) / 2;
        int y = (this.f_96544_ - 192) / 2;
        this.nextPage = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), b -> {
            if (this.page < 1) {
                ++this.page;
            }
            this.updateButtons();
        }).m_252987_(x + 213, y + 160, 23, 13).m_253136_());
        this.previousPage = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> {
            if (this.page > 0) {
                --this.page;
            }
            this.updateButtons();
        }).m_252987_(x + 15, y + 160, 23, 13).m_253136_());
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.nextPage != null) {
            boolean bl = this.nextPage.f_93624_ = this.page < 1;
        }
        if (this.previousPage != null) {
            this.previousPage.f_93624_ = this.page > 0;
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        int x = (this.f_96543_ - 256) / 2;
        int y = (this.f_96544_ - 192) / 2;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        guiGraphics.m_280163_(BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, 256, 256, 256, 256);
        Font font = Minecraft.m_91087_().f_91062_;
        String dinoName = LangUtil.getDinoName(this.entity.getDinosaur()).getString().toUpperCase(Locale.ENGLISH);
        this.drawScaledString(guiGraphics, dinoName, x + 15, y + 14, 1.3f, 0);
        if (this.page == 0) {
            this.drawScaledString(guiGraphics, this.entity.getGrowthStage().getLocalization().toUpperCase(Locale.ENGLISH) + " // " + LangUtil.getGenderMode(this.entity.isMale() ? 1 : 2).toUpperCase(Locale.ENGLISH), x + 16, y + 24, 1.0f, 0);
            int statisticsX = x + 128 + 15;
            int statisticTextX = x + 192;
            this.drawScaledString(guiGraphics, LangUtil.translate(LangUtil.GUI.get("dinosaur_statistics")), statisticsX, y + 14, 1.0f, 0);
            this.drawCenteredScaledString(guiGraphics, LangUtil.translate(LangUtil.GUI.get("health")), statisticTextX, y + 35, 1.0f, 0);
            this.drawCenteredScaledString(guiGraphics, LangUtil.translate(LangUtil.GUI.get("hunger")), statisticTextX, y + 65, 1.0f, 0);
            this.drawCenteredScaledString(guiGraphics, LangUtil.translate(LangUtil.GUI.get("thirst")), statisticTextX, y + 95, 1.0f, 0);
            this.drawCenteredScaledString(guiGraphics, LangUtil.translate(LangUtil.GUI.get("age")), statisticTextX, y + 125, 1.0f, 0);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGETS_TEXTURE);
            this.drawBar(guiGraphics, statisticsX, y + 45, this.entity.isCarcass() ? 0.0f : this.entity.m_21223_(), this.entity.m_21233_(), 0xFF0000);
            this.drawBar(guiGraphics, statisticsX, y + 75, this.guideInfo.hunger, this.entity.getMetabolism().getMaxEnergy(), 9729114);
            this.drawBar(guiGraphics, statisticsX, y + 105, this.guideInfo.thirst, this.entity.getMetabolism().getMaxWater(), 255);
            this.drawBar(guiGraphics, statisticsX, y + 135, this.entity.getDinosaurAge(), this.entity.getDinosaur().getMaximumAge(), 65280);
            this.drawCenteredScaledString(guiGraphics, LangUtil.translate(LangUtil.GUI.get("days_old")).replace("{value}", String.valueOf(this.entity.getDaysExisted())), statisticTextX, y + 155, 1.0f, 0);
            this.renderDinosaurEntity(guiGraphics.m_280168_(), x + 65, y + 110, (int)(70.0 / ((double)this.entity.getDinosaur().getAdultSizeY() + (2.0 * this.entity.getDinosaur().getScaleAdult() + this.entity.getDinosaur().getPaleoPadScale()))), this.entity);
            int statusX = 0;
            int statusY = 0;
            List<DinosaurStatus> activeStatuses = DinosaurStatus.getActiveStatuses(this.entity, this.guideInfo);
            for (DinosaurStatus status : activeStatuses) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)STATUS_TEXTURES.get((Object)status));
                guiGraphics.m_280163_(STATUS_TEXTURES.get((Object)status), statusX + x + 31, statusY + y + 152, 0.0f, 0.0f, 16, 16, 16, 16);
                if ((statusX += 18) <= 68) continue;
                statusX = 0;
                statusY -= 18;
            }
            statusX = 0;
            statusY = 0;
            for (DinosaurStatus status : activeStatuses) {
                int size = 16;
                int renderX = statusX + x + 31;
                int renderY = statusY + y + 152;
                if (mouseX >= renderX && mouseY >= renderY && mouseX <= renderX + size && mouseY <= renderY + size) {
                    guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)LangUtil.translate(LangUtil.STATUS.get(status.name().toLowerCase(Locale.ENGLISH)))), mouseX, mouseY);
                }
                if ((statusX += 18) <= 68) continue;
                statusX = 0;
                statusY -= 18;
            }
        } else {
            String text = LangUtil.getDinoInfo(this.entity.getDinosaur());
            ArrayList<String> lines = new ArrayList<String>();
            int wrapX = 0;
            StringBuilder wrapLine = new StringBuilder();
            for (String word : text.split(" ")) {
                if (wrapX + font.m_92895_(word) > 220) {
                    lines.add(wrapLine.toString());
                    wrapLine = new StringBuilder();
                }
                wrapLine.append(word).append(" ");
                wrapX = font.m_92895_(wrapLine.toString().trim());
            }
            lines.add(wrapLine.toString());
            int lineX = 0;
            int lineY = y + 35;
            for (String line : lines) {
                this.drawCenteredScaledString(guiGraphics, line.trim(), x + 128 + lineX, lineY, 1.0f, 0);
                if ((lineY += 10) <= y + 192 - 35) continue;
                lineX += 128;
                lineY = y + 10;
            }
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void drawBar(GuiGraphics guiGraphics, int x, int y, float value, float max, int color) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(WIDGETS_TEXTURE, x, y, 0.0f, 179.0f, 98, 8, 256, 256);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        guiGraphics.m_280163_(WIDGETS_TEXTURE, x, y, 0.0f, 187.0f, Math.max(0, Math.min(98, (int)(value / max * 98.0f))), 8, 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawScaledString(GuiGraphics guiGraphics, String text, float x, float y, float scale, int color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, text, 0, 0, color, false);
        poseStack.m_85849_();
    }

    private void drawCenteredScaledString(GuiGraphics guiGraphics, String text, float x, float y, float scale, int color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        int drawX = Math.round((float)(-font.m_92895_(text)) / 2.0f);
        guiGraphics.m_280056_(font, text, drawX, 0, color, false);
        poseStack.m_85849_();
    }

    private void renderDinosaurEntity(PoseStack poseStack, int posX, int posY, float scale, DinosaurEntity entity) {
        EntityRenderDispatcher renderDispatcher = Minecraft.m_91087_().m_91290_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)posX, (float)posY, 50.0f);
        poseStack.m_85841_(-scale, scale, scale);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        renderDispatcher.m_114468_(false);
        Minecraft mc = Minecraft.m_91087_();
        renderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, mc.m_91296_(), poseStack, (MultiBufferSource)mc.m_91269_().m_110104_(), 0xF000F0);
        mc.m_91269_().m_110104_().m_109911_();
        renderDispatcher.m_114468_(true);
        poseStack.m_85849_();
    }

    public boolean m_7043_() {
        return false;
    }

    static {
        for (DinosaurStatus status : DinosaurStatus.values()) {
            STATUS_TEXTURES.put(status, new ResourceLocation("jurassicreborn", "textures/field_guide/status/" + status.name().toLowerCase(Locale.ENGLISH) + ".png"));
        }
    }
}

