/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.vit.jurassicreborn.client.screens.HologramSelectScreen;
import net.vit.jurassicreborn.common.blocks.entities.HologramBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.ModBlockEntities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HologramBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.m_83144_();

    public HologramBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new HologramBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            this.openClientGui(pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    private void openClientGui(BlockPos pos) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.doOpenScreen(pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doOpenScreen(BlockPos pos) {
        Minecraft mc = Minecraft.m_91087_();
        BlockEntity be = mc.f_91073_.m_7702_(pos);
        int current = 0;
        int pose = 0;
        boolean rotating = true;
        int rotation = 0;
        if (be instanceof HologramBlockEntity) {
            HologramBlockEntity hologram = (HologramBlockEntity)be;
            current = hologram.getDinoIndex();
            pose = hologram.getPoseIndex();
            rotating = hologram.isRotating();
            rotation = hologram.getRot();
        }
        mc.m_91152_((Screen)new HologramSelectScreen(pos, current, pose, rotating, rotation));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (level.f_46443_) {
            return;
        }
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof HologramBlockEntity)) {
            return;
        }
        HologramBlockEntity hologram = (HologramBlockEntity)be;
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null) {
            hologram.applySettingsFromTag(tag, true);
        }
    }

    private ItemStack createItemStack(HologramBlockEntity hologram) {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag blockEntityTag = new CompoundTag();
        blockEntityTag.m_128405_("DinoIndex", hologram.getDinoIndex());
        blockEntityTag.m_128405_("PoseIndex", hologram.getPoseIndex());
        blockEntityTag.m_128379_("Rotating", hologram.isRotating());
        blockEntityTag.m_128405_("Rotation", hologram.getRot());
        stack.m_41700_("BlockEntityTag", (Tag)blockEntityTag);
        return stack;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof HologramBlockEntity) {
            HologramBlockEntity hologram = (HologramBlockEntity)be;
            return this.createItemStack(hologram);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        BlockEntity be = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (be instanceof HologramBlockEntity) {
            HologramBlockEntity hologram = (HologramBlockEntity)be;
            drops.add(this.createItemStack(hologram));
        } else {
            drops.add(new ItemStack((ItemLike)this));
        }
        return drops;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (type == ModBlockEntities.HOLOGRAM_BLOCK_ENTITY.get()) {
            return (lvl, pos1, state1, be) -> {
                if (be instanceof HologramBlockEntity) {
                    HologramBlockEntity hologram = (HologramBlockEntity)be;
                    if (lvl.f_46443_) {
                        hologram.clientTick(lvl, pos1, state1);
                    } else {
                        hologram.serverTick(lvl, pos1, state1);
                    }
                }
            };
        }
        return null;
    }
}

