/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.vit.jurassicreborn.common.util.networking.Syncable;
import org.jetbrains.annotations.Nullable;

public abstract class MachineBaseBlockEntity<A extends MachineBaseBlockEntity>
extends RandomizableContainerBlockEntity
implements Syncable,
BlockEntityTicker<A>,
WorldlyContainer {
    protected String customName;
    protected int[] processTime = new int[this.getProcessCount()];
    protected int[] totalProcessTime = new int[this.getProcessCount()];
    IItemHandler handler = new SidedInvWrapper((WorldlyContainer)this, Direction.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((WorldlyContainer)this, Direction.DOWN);

    protected MachineBaseBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        NonNullList inventory = NonNullList.m_122779_();
        if (compound.m_128441_("Items")) {
            ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("Items"), (NonNullList)inventory);
        }
        for (int i = 0; i < this.getProcessCount(); ++i) {
            this.processTime[i] = compound.m_128448_("ProcessTime" + i);
            this.totalProcessTime[i] = compound.m_128448_("ProcessTimeTotal" + i);
        }
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = compound.m_128461_("CustomName");
        }
        this.setSlots((NonNullList<ItemStack>)inventory);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        for (int i = 0; i < this.getProcessCount(); ++i) {
            compound.m_128405_("ProcessTime" + i, (int)((short)this.processTime[i]));
            compound.m_128405_("ProcessTimeTotal" + i, (int)((short)this.totalProcessTime[i]));
        }
        NonNullList<ItemStack> slots = this.getSlots();
        CompoundTag items = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)items, slots, (boolean)true);
        compound.m_128365_("Items", (Tag)items);
        if (this.m_8077_()) {
            compound.m_128359_("CustomName", this.customName);
        }
    }

    public ItemStack m_8020_(int index) {
        try {
            if (this.getSlots().size() >= index || this.getSlots().size() != index) {
                return (ItemStack)this.getSlots().get(index);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        this.m_59640_(null);
        return ContainerHelper.m_18969_((List)this.m_7086_(), (int)pIndex, (int)pCount);
    }

    @Override
    public NonNullList getSyncFields(NonNullList fields) {
        return fields;
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_((List)this.m_7086_(), (int)0);
    }

    public void m_6836_(int index, ItemStack stack) {
        NonNullList<ItemStack> slots = this.getSlots();
        boolean stacksEqual = !stack.m_41619_() && stack.m_150930_(((ItemStack)slots.get(index)).m_41720_()) && ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)slots.get(index)));
        slots.set(index, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.getInventoryStackLimit()) {
            stack.m_41764_(this.getInventoryStackLimit());
        }
        if (!stacksEqual) {
            int process = this.getProcess(index);
            if (process >= 0 && process < this.getProcessCount()) {
                this.totalProcessTime[process] = this.getStackProcessTime(stack);
                if (!this.canProcess(process)) {
                    this.processTime[process] = 0;
                }
                this.m_6596_();
            }
            this.onSlotUpdate();
        }
    }

    private boolean isInput(int slot) {
        int[] inputs;
        for (int input : inputs = this.getInputs()) {
            if (input != slot) continue;
            return true;
        }
        return false;
    }

    private boolean isOutput(int slot) {
        int[] outputs;
        for (int output : outputs = this.getOutputs()) {
            if (output != slot) continue;
            return true;
        }
        return false;
    }

    public boolean m_8077_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomInventoryName(String customName) {
        this.customName = customName;
    }

    public int m_6643_() {
        return this.getSlots().size();
    }

    public boolean isProcessing(int index) {
        return this.processTime[index] > 0;
    }

    public void tick(Level world, BlockPos pPos, BlockState pState, A pBlockEntity) {
        NonNullList<ItemStack> slots = this.getSlots();
        if (!world.f_46443_) {
            for (int process = 0; process < this.getProcessCount(); ++process) {
                boolean flag = this.isProcessing(process);
                boolean dirty = false;
                boolean hasInput = false;
                for (int input : this.getInputs(process)) {
                    if (slots.size() <= input || ((ItemStack)slots.get(input)).m_41619_()) continue;
                    hasInput = true;
                    break;
                }
                if (hasInput && this.canProcess(process)) {
                    int n = process;
                    this.processTime[n] = this.processTime[n] + 1;
                    if (this.processTime[process] >= this.totalProcessTime[process]) {
                        this.processTime[process] = 0;
                        int total = 0;
                        for (int input : this.getInputs()) {
                            ItemStack stack = (ItemStack)slots.get(input);
                            if (stack.m_41619_()) continue;
                            total = this.getStackProcessTime(stack);
                            break;
                        }
                        this.totalProcessTime[process] = total;
                        if (!world.f_46443_) {
                            this.processItem(process);
                            this.onSlotUpdate();
                        }
                    }
                    dirty = true;
                } else if (this.isProcessing(process)) {
                    if (this.shouldResetProgress()) {
                        this.processTime[process] = 0;
                    } else if (this.processTime[process] > 0) {
                        int n = process;
                        this.processTime[n] = this.processTime[n] - 1;
                    }
                    dirty = true;
                }
                if (flag != this.isProcessing(process)) {
                    dirty = true;
                }
                if (!dirty || world.f_46443_) continue;
                this.m_6596_();
            }
        }
    }

    public boolean m_7525_(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return !this.isOutput(pIndex);
    }

    public int[] m_7071_(Direction side) {
        return side == Direction.DOWN ? this.getOutputs() : this.getInputs();
    }

    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        return this.m_7013_(index, stack);
    }

    protected int getProcess(int slot) {
        return slot;
    }

    protected boolean canProcess(int process) {
        return true;
    }

    protected void processItem(int process) {
    }

    protected int getMainOutput(int process) {
        return 0;
    }

    protected int getStackProcessTime(ItemStack stack) {
        return 0;
    }

    protected int getProcessCount() {
        return 0;
    }

    protected abstract int[] getInputs();

    protected abstract int[] getInputs(int var1);

    protected abstract int[] getOutputs();

    protected abstract NonNullList<ItemStack> getSlots();

    public boolean hasOutputSlot(ItemStack output) {
        return this.getOutputSlot(output) != -1;
    }

    public int getOutputSlot(ItemStack output) {
        int[] outputs;
        NonNullList<ItemStack> slots = this.getSlots();
        for (int slot : outputs = this.getOutputs()) {
            ItemStack stack = (ItemStack)slots.get(slot);
            if (!stack.m_41619_() && (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)output) || stack.m_41613_() + output.m_41613_() > stack.m_41741_() || stack.m_41720_() != output.m_41720_() || stack.m_41773_() != output.m_41773_())) continue;
            return slot;
        }
        return -1;
    }

    public int getField(int id) {
        int processCount = this.getProcessCount();
        if (id < processCount) {
            return this.processTime[id];
        }
        if (id < processCount * 2) {
            return this.totalProcessTime[id - processCount];
        }
        return 0;
    }

    public void setField(int id, int value) {
        int processCount = this.getProcessCount();
        if (id < processCount) {
            this.processTime[id] = value;
        } else if (id < processCount * 2) {
            this.totalProcessTime[id - processCount] = value;
        }
    }

    public int getFieldCount() {
        return this.getProcessCount() * 2;
    }

    public void clear() {
        NonNullList<ItemStack> slots = this.getSlots();
        for (int i = 0; i < slots.size(); ++i) {
            slots.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public void m_6211_() {
        this.clear();
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }

    protected void mergeStack(int slot, ItemStack stack) {
        NonNullList<ItemStack> slots = this.getSlots();
        ItemStack previous = (ItemStack)slots.get(slot);
        if (previous.m_41619_()) {
            slots.set(slot, (Object)stack);
        } else if (ItemStack.m_150942_((ItemStack)previous, (ItemStack)stack) && ItemStack.m_150942_((ItemStack)previous, (ItemStack)stack)) {
            previous.m_41764_(previous.m_41613_() + stack.m_41613_());
        }
    }

    protected void decreaseStackSize(int slot) {
        NonNullList<ItemStack> slots = this.getSlots();
        ((ItemStack)slots.get(slot)).m_41774_(1);
        if (((ItemStack)slots.get(slot)).m_41613_() <= 0) {
            slots.set(slot, (Object)ItemStack.f_41583_);
        }
    }

    public int getInventoryStackLimit() {
        return this.m_6893_();
    }

    public int m_6893_() {
        return 64;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    protected boolean shouldResetProgress() {
        return true;
    }

    protected void setSlots(NonNullList<ItemStack> slots) {
    }

    protected void onSlotUpdate() {
    }

    public boolean m_7983_() {
        return false;
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"jurassicreborn:machine_base_block");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.DOWN) {
                return LazyOptional.of(() -> this.handlerBottom == null ? (this.handlerBottom = new SidedInvWrapper((WorldlyContainer)this, Direction.DOWN)) : this.handlerBottom);
            }
            return LazyOptional.of(() -> this.handler == null ? (this.handler = new SidedInvWrapper((WorldlyContainer)this, Direction.UP)) : this.handler);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void packetDataHandler(ByteBuf fields) {
    }
}

