/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.cultivator;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.base.BaseMachineBlock;
import net.vit.jurassicreborn.common.blocks.entities.cultivator.CultivatorBlockEntity;
import net.vit.jurassicreborn.common.blocks.entities.cultivator.CultivatorBottomBlock;
import net.vit.jurassicreborn.common.blocks.entities.cultivator.CultivatorTopBlock;
import net.vit.jurassicreborn.common.blocks.entities.cultivator.CultivatorTopBlockEntity;

public class CultivatorBlock
extends BaseMachineBlock {
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.m_61587_((String)"color", DyeColor.class);
    public final boolean half;

    public CultivatorBlock(BlockBehaviour.Properties properties, boolean blockHalf) {
        super(properties);
        this.half = blockHalf;
        this.m_49959_((BlockState)this.getSetDefaultValues().m_61124_(COLOR, (Comparable)DyeColor.WHITE));
    }

    public static void placeBottomAt(LevelAccessor level, BlockState state, BlockPos pos, int flags) {
        BlockPos blockpos = pos.m_7494_();
        level.m_7731_(pos, DoublePlantBlock.m_182453_((LevelReader)level, (BlockPos)pos, (BlockState)((CultivatorBottomBlock)((Object)ModBlocks.CULTIVATE_BOTTOM.get())).m_49966_()), flags);
        level.m_7731_(blockpos, DoublePlantBlock.m_182453_((LevelReader)level, (BlockPos)blockpos, (BlockState)((CultivatorTopBlock)((Object)ModBlocks.CULTIVATE_TOP.get())).m_49966_()), flags);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (level.f_46443_) {
            return;
        }
        if (state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, level, pos, newState, isMoving);
            return;
        }
        BlockPos bottomPos = this.half ? pos.m_7495_() : pos;
        BlockEntity be = level.m_7702_(bottomPos);
        if (be instanceof CultivatorBlockEntity) {
            CultivatorBlockEntity entity = (CultivatorBlockEntity)be;
            Containers.m_19002_((Level)level, (BlockPos)bottomPos, (Container)new RecipeWrapper(entity.getItemHandler()));
            level.m_46717_(bottomPos, (Block)this);
        }
        BlockPos otherHalf = this.half ? bottomPos : bottomPos.m_7494_();
        level.m_46961_(otherHalf, false);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        return ((DyeColor)state.m_61143_(COLOR)).m_284406_();
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CultivatorBlockEntity) {
            CultivatorBlockEntity e = (CultivatorBlockEntity)blockEntity;
            player.m_5893_((MenuProvider)e);
        } else {
            blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CultivatorTopBlockEntity) {
                CultivatorTopBlockEntity e = (CultivatorTopBlockEntity)blockEntity;
                player.m_5893_((MenuProvider)e);
            }
        }
        return InteractionResult.CONSUME;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return !this.half ? level.m_8055_(pos.m_7494_()).m_60795_() : true;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (level.f_46443_) {
            return;
        }
        if (this.half) {
            return;
        }
        level.m_7731_(pos.m_7494_(), (BlockState)((CultivatorTopBlock)((Object)ModBlocks.CULTIVATE_TOP.get())).m_49966_().m_61124_(COLOR, (Comparable)((DyeColor)state.m_61143_(COLOR))), 3);
    }

    public boolean areBothHalvesValid(BlockState state, BlockPos pos, Level level) {
        Block block = state.m_60734_();
        if (!(block instanceof CultivatorBlock)) {
            return false;
        }
        CultivatorBlock cultivator = (CultivatorBlock)block;
        pos = cultivator.half ? pos.m_7495_() : pos.m_7494_();
        Block block2 = level.m_8055_(pos).m_60734_();
        if (!(block2 instanceof CultivatorBlock)) {
            return false;
        }
        CultivatorBlock otherHalf = (CultivatorBlock)block2;
        return cultivator.half != otherHalf.half;
    }

    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> given, BlockEntityType<E> expected, BlockEntityTicker<? super E> ticker) {
        return expected == given ? ticker : null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> b) {
        super.m_7926_(b);
        b.m_61104_(new Property[]{COLOR});
    }
}

