/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.blocks.entities.skeletonassembly;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.entities.ModMenuTypes;
import net.vit.jurassicreborn.common.blocks.entities.skeletonassembly.FossilCraftSlot;
import net.vit.jurassicreborn.common.blocks.entities.skeletonassembly.SkeletonAssemblerItemHandler;
import net.vit.jurassicreborn.common.blocks.entities.skeletonassembly.SkeletonResultSlot;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.items.Fossils.FossilItem;
import net.vit.jurassicreborn.common.items.ModItems;
import org.jetbrains.annotations.NotNull;

public class SkeletonAssemblerMenu
extends AbstractContainerMenu {
    private static final int RESULT_SLOT = 25;
    private static final int RESULT_IDX = 0;
    private static final int GRID_FIRST = 1;
    private static final int GRID_LAST = 25;
    private static final int INV_FIRST = 26;
    private static final int HOTBAR_FIRST = 53;
    private static final int GRID_W = 5;
    private static final int GRID_H = 5;
    private final Container grid;
    private final Container result;
    private final ContainerLevelAccess access;

    public SkeletonAssemblerMenu(int id, Inventory playerInv, IItemHandlerModifiable handler, ContainerData syncData, BlockPos pos) {
        super((MenuType)ModMenuTypes.SKELETON_ASSEMBLER.get(), id);
        ItemStack result;
        this.access = ContainerLevelAccess.m_39289_((Level)playerInv.f_35978_.m_9236_(), (BlockPos)pos);
        this.grid = (Container)handler;
        this.result = (Container)handler;
        if (handler instanceof SkeletonAssemblerItemHandler) {
            SkeletonAssemblerItemHandler sa = (SkeletonAssemblerItemHandler)handler;
            sa.setChangeListener(() -> this.m_6199_(sa));
        }
        this.m_38884_(syncData);
        this.m_38897_(new SkeletonResultSlot(playerInv.f_35978_, this.grid, this.result, 25, 140, 52));
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                int idx = x + y * 5;
                this.m_38897_(new FossilCraftSlot(this.grid, idx, 16 + x * 18, 16 + y * 18));
            }
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 119 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 177));
        }
        if (this.grid.m_8020_(25).m_41619_() && !(result = this.computeResult()).m_41619_()) {
            this.grid.m_6836_(25, result);
        }
    }

    public SkeletonAssemblerMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, (IItemHandlerModifiable)new SkeletonAssemblerItemHandler(), (ContainerData)new SimpleContainerData(2), buf.m_130135_());
    }

    public void m_6199_(Container changed) {
        if (changed == this.grid) {
            ItemStack current = this.grid.m_8020_(25);
            ItemStack result = this.computeResult();
            if (current.m_41619_()) {
                if (!result.m_41619_()) {
                    this.grid.m_6836_(25, result);
                }
            } else if (result.m_41619_()) {
                this.grid.m_6836_(25, ItemStack.f_41583_);
            }
        }
        super.m_6199_(changed);
    }

    private ItemStack computeResult() {
        AssemblyData data = this.findAssemblyData();
        if (data == null || data.dino.getRecipe() == null) {
            return ItemStack.f_41583_;
        }
        String[][] recipe = data.dino.getRecipe();
        Bounds b = this.boundsOfBones();
        if (b.width() + 1 != recipe[0].length || b.height() + 1 != recipe.length) {
            return ItemStack.f_41583_;
        }
        for (int y = 0; y < recipe.length; ++y) {
            for (int x = 0; x < recipe[0].length; ++x) {
                ItemStack in = this.grid.m_8020_(x + b.minX + (y + b.minY) * 5);
                if (recipe[y][x].equals(this.boneType(in))) continue;
                return ItemStack.f_41583_;
            }
        }
        return data.makeResult();
    }

    private AssemblyData findAssemblyData() {
        AssemblyData found = null;
        for (int i = 0; i < 25; ++i) {
            ItemStack stack = this.grid.m_8020_(i);
            AssemblyData d = this.assemblyOf(stack);
            if (d == null) continue;
            if (found != null && !found.equals(d)) {
                return null;
            }
            found = d;
        }
        return found;
    }

    private AssemblyData assemblyOf(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof FossilItem) {
            FossilItem fi = (FossilItem)item;
            return new AssemblyData(fi.getDinosaur(stack), fi.isFresh());
        }
        return null;
    }

    private String boneType(ItemStack stack) {
        String string;
        Item item = stack.m_41720_();
        if (item instanceof FossilItem) {
            FossilItem fi = (FossilItem)item;
            string = fi.getBoneType();
        } else {
            string = "";
        }
        return string;
    }

    private Bounds boundsOfBones() {
        int minX = 5;
        int minY = 5;
        int maxX = -1;
        int maxY = -1;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                if (this.assemblyOf(this.grid.m_8020_(x + y * 5)) == null) continue;
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y);
            }
        }
        return new Bounds(minX, minY, maxX, maxY);
    }

    @NotNull
    public ItemStack m_7648_(Player player, int idx) {
        Slot slot = (Slot)this.f_38839_.get(idx);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack copy = stack.m_41777_();
        if (idx == 0) {
            if (!this.m_38903_(stack, 26, 62, true)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(stack, copy);
            slot.m_142406_(player, stack);
        } else if (idx >= 26 ? !this.m_38903_(stack, 1, 26, false) : !this.m_38903_(stack, 26, 62, false)) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return copy;
    }

    public boolean m_6875_(@NotNull Player p) {
        return (Boolean)this.access.m_39299_((lvl, pos) -> lvl.m_8055_(pos).m_60713_((Block)ModBlocks.SKELETON_ASSEMBLY.get()) && p.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    private record AssemblyData(Dinosaur dino, boolean fresh) {
        ItemStack makeResult() {
            return new ItemStack(this.fresh ? (ItemLike)ModItems.FRESH_SKELETONS.get(this.dino).get() : (ItemLike)ModItems.FOSSIL_SKELETONS.get(this.dino).get());
        }
    }

    private record Bounds(int minX, int minY, int maxX, int maxY) {
        int width() {
            return this.maxX - this.minX;
        }

        int height() {
            return this.maxY - this.minY;
        }
    }
}

