/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.AABB;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class AnimationCommand {
    public static void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"animation").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"dino", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"anim", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, b) -> {
            for (EntityAnimation a : EntityAnimation.values()) {
                b.suggest(a.name().toLowerCase(Locale.ROOT));
            }
            return b.buildFuture();
        }).executes(AnimationCommand::run))));
    }

    private static int run(CommandContext<CommandSourceStack> ctx) {
        EntityAnimation anim;
        ResourceLocation dinoId = ResourceLocationArgument.m_107011_(ctx, (String)"dino");
        String animKey = ResourceLocationArgument.m_107011_(ctx, (String)"anim").m_135815_();
        try {
            anim = EntityAnimation.valueOf(animKey.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown animation: " + animKey)));
            return 0;
        }
        EntityType type = BuiltInRegistries.f_256780_.m_6612_(dinoId).orElse(null);
        if (type == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown dinosaur id: " + dinoId)));
            return 0;
        }
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        int played = 0;
        AABB worldBox = new AABB(-2.147483648E9, (double)level.m_141937_(), -2.147483648E9, 2.147483647E9, (double)level.m_151558_(), 2.147483647E9);
        for (DinosaurEntity dino : level.m_6443_(DinosaurEntity.class, worldBox, e -> e.m_6095_() == type)) {
            dino.setAnimation(anim.get());
            ++played;
        }
        if (played == 0) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("No living " + dinoId + " found")));
            return 0;
        }
        int totalPlayed = played;
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Played " + animKey + " on " + totalPlayed + " " + dinoId)), true);
        return played;
    }
}

