/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.datagen;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.block.Block;
import net.vit.jurassicreborn.common.blocks.ModBlocks;
import net.vit.jurassicreborn.common.blocks.wood.WoodBlocks;
import org.jetbrains.annotations.Nullable;

public class ModBlockFamilies {
    private static final Map<Block, ModBlockFamily> MAP = Maps.newHashMap();
    public static final ModBlockFamily MAGNOLIA_PLANKS = ModBlockFamilies.familyBuilder((Block)WoodBlocks.MAGNOLIA_PLANKS.get()).button((Block)WoodBlocks.MAGNOLIA_BUTTON.get()).fence((Block)WoodBlocks.MAGNOLIA_FENCE.get()).fenceGate((Block)WoodBlocks.MAGNOLIA_FENCE_GATE.get()).pressurePlate((Block)WoodBlocks.MAGNOLIA_PRESSURE_PLATE.get()).sign((Block)WoodBlocks.MAGNOLIA_SIGN.get(), (Block)WoodBlocks.MAGNOLIA_WALL_SIGN.get()).hangingSign((Block)WoodBlocks.MAGNOLIA_HANGING_SIGN.get(), (Block)WoodBlocks.MAGNOLIA_WALL_HANGING_SIGN.get()).slab((Block)WoodBlocks.MAGNOLIA_SLAB.get()).stairs((Block)WoodBlocks.MAGNOLIA_STAIRS.get()).door((Block)WoodBlocks.MAGNOLIA_DOOR.get()).trapdoor((Block)WoodBlocks.MAGNOLIA_TRAPDOOR.get()).recipeGroupPrefix("wooden").recipeUnlockedBy("has_planks").getFamily();
    public static final ModBlockFamily GINKGO_PLANKS = ModBlockFamilies.familyBuilder((Block)WoodBlocks.GINKGO_PLANKS.get()).button((Block)WoodBlocks.GINKGO_BUTTON.get()).fence((Block)WoodBlocks.GINKGO_FENCE.get()).fenceGate((Block)WoodBlocks.GINKGO_FENCE_GATE.get()).pressurePlate((Block)WoodBlocks.GINKGO_PRESSURE_PLATE.get()).sign((Block)WoodBlocks.GINKGO_SIGN.get(), (Block)WoodBlocks.GINKGO_WALL_SIGN.get()).hangingSign((Block)WoodBlocks.GINKGO_HANGING_SIGN.get(), (Block)WoodBlocks.GINKGO_WALL_HANGING_SIGN.get()).slab((Block)WoodBlocks.GINKGO_SLAB.get()).stairs((Block)WoodBlocks.GINKGO_STAIRS.get()).door((Block)WoodBlocks.GINKGO_DOOR.get()).trapdoor((Block)WoodBlocks.GINKGO_TRAPDOOR.get()).recipeGroupPrefix("wooden").recipeUnlockedBy("has_planks").getFamily();
    public static final ModBlockFamily CALAMITES_PLANKS = ModBlockFamilies.familyBuilder((Block)WoodBlocks.CALAMITES_PLANKS.get()).button((Block)WoodBlocks.CALAMITES_BUTTON.get()).fence((Block)WoodBlocks.CALAMITES_FENCE.get()).fenceGate((Block)WoodBlocks.CALAMITES_FENCE_GATE.get()).pressurePlate((Block)WoodBlocks.CALAMITES_PRESSURE_PLATE.get()).sign((Block)WoodBlocks.CALAMITES_SIGN.get(), (Block)WoodBlocks.CALAMITES_WALL_SIGN.get()).hangingSign((Block)WoodBlocks.CALAMITES_HANGING_SIGN.get(), (Block)WoodBlocks.CALAMITES_WALL_HANGING_SIGN.get()).slab((Block)WoodBlocks.CALAMITES_SLAB.get()).stairs((Block)WoodBlocks.CALAMITES_STAIRS.get()).door((Block)WoodBlocks.CALAMITES_DOOR.get()).trapdoor((Block)WoodBlocks.CALAMITES_TRAPDOOR.get()).recipeGroupPrefix("wooden").recipeUnlockedBy("has_planks").getFamily();
    public static final ModBlockFamily PHOENIX_PLANKS = ModBlockFamilies.familyBuilder((Block)WoodBlocks.PHOENIX_PLANKS.get()).button((Block)WoodBlocks.PHOENIX_BUTTON.get()).fence((Block)WoodBlocks.PHOENIX_FENCE.get()).fenceGate((Block)WoodBlocks.PHOENIX_FENCE_GATE.get()).pressurePlate((Block)WoodBlocks.PHOENIX_PRESSURE_PLATE.get()).sign((Block)WoodBlocks.PHOENIX_SIGN.get(), (Block)WoodBlocks.PHOENIX_WALL_SIGN.get()).hangingSign((Block)WoodBlocks.PHOENIX_HANGING_SIGN.get(), (Block)WoodBlocks.PHOENIX_WALL_HANGING_SIGN.get()).slab((Block)WoodBlocks.PHOENIX_SLAB.get()).stairs((Block)WoodBlocks.PHOENIX_STAIRS.get()).door((Block)WoodBlocks.PHOENIX_DOOR.get()).trapdoor((Block)WoodBlocks.PHOENIX_TRAPDOOR.get()).recipeGroupPrefix("wooden").recipeUnlockedBy("has_planks").getFamily();
    public static final ModBlockFamily PSARONIUS_PLANKS = ModBlockFamilies.familyBuilder((Block)WoodBlocks.PSARONIUS_PLANKS.get()).button((Block)WoodBlocks.PSARONIUS_BUTTON.get()).fence((Block)WoodBlocks.PSARONIUS_FENCE.get()).fenceGate((Block)WoodBlocks.PSARONIUS_FENCE_GATE.get()).pressurePlate((Block)WoodBlocks.PSARONIUS_PRESSURE_PLATE.get()).sign((Block)WoodBlocks.PSARONIUS_SIGN.get(), (Block)WoodBlocks.PSARONIUS_WALL_SIGN.get()).hangingSign((Block)WoodBlocks.PSARONIUS_HANGING_SIGN.get(), (Block)WoodBlocks.PSARONIUS_WALL_HANGING_SIGN.get()).slab((Block)WoodBlocks.PSARONIUS_SLAB.get()).stairs((Block)WoodBlocks.PSARONIUS_STAIRS.get()).door((Block)WoodBlocks.PSARONIUS_DOOR.get()).trapdoor((Block)WoodBlocks.PSARONIUS_TRAPDOOR.get()).recipeGroupPrefix("wooden").recipeUnlockedBy("has_planks").getFamily();
    public static final ModBlockFamily ARAUCARIA_PLANKS = ModBlockFamilies.familyBuilder((Block)WoodBlocks.ARAUCARIA_PLANKS.get()).button((Block)WoodBlocks.ARAUCARIA_BUTTON.get()).fence((Block)WoodBlocks.ARAUCARIA_FENCE.get()).fenceGate((Block)WoodBlocks.ARAUCARIA_FENCE_GATE.get()).pressurePlate((Block)WoodBlocks.ARAUCARIA_PRESSURE_PLATE.get()).sign((Block)WoodBlocks.ARAUCARIA_SIGN.get(), (Block)WoodBlocks.ARAUCARIA_WALL_SIGN.get()).hangingSign((Block)WoodBlocks.ARAUCARIA_HANGING_SIGN.get(), (Block)WoodBlocks.ARAUCARIA_WALL_HANGING_SIGN.get()).slab((Block)WoodBlocks.ARAUCARIA_SLAB.get()).stairs((Block)WoodBlocks.ARAUCARIA_STAIRS.get()).door((Block)WoodBlocks.ARAUCARIA_DOOR.get()).trapdoor((Block)WoodBlocks.ARAUCARIA_TRAPDOOR.get()).recipeGroupPrefix("wooden").recipeUnlockedBy("has_planks").getFamily();
    public static final ModBlockFamily GYPSUM_BRICKS = ModBlockFamilies.familyBuilder((Block)ModBlocks.GYPSUM_BRICKS.get()).button((Block)ModBlocks.GYPSUM_BRICK_BUTTON.get()).pressurePlate((Block)ModBlocks.GYPSUM_BRICK_PRESSURE_PLATE.get()).slab((Block)ModBlocks.GYPSUM_BRICK_SLAB.get()).stairs((Block)ModBlocks.GYPSUM_BRICK_STAIRS.get()).wall((Block)ModBlocks.GYPSUM_BRICK_WALL.get()).getFamily();
    public static final ModBlockFamily REINFORCED_BRICKS = ModBlockFamilies.familyBuilder((Block)ModBlocks.REINFORCED_BRICKS.get()).button((Block)ModBlocks.REINFORCED_BRICK_BUTTON.get()).pressurePlate((Block)ModBlocks.REINFORCED_BRICK_PRESSURE_PLATE.get()).slab((Block)ModBlocks.REINFORCED_BRICK_SLAB.get()).stairs((Block)ModBlocks.REINFORCED_BRICK_STAIRS.get()).wall((Block)ModBlocks.REINFORCED_BRICK_WALL.get()).getFamily();
    public static final ModBlockFamily GYPSUM_STONE = ModBlockFamilies.familyBuilder((Block)ModBlocks.GYPSUM_STONE.get()).button((Block)ModBlocks.GYPSUM_STONE_BUTTON.get()).pressurePlate((Block)ModBlocks.GYPSUM_STONE_PRESSURE_PLATE.get()).slab((Block)ModBlocks.GYPSUM_STONE_SLAB.get()).stairs((Block)ModBlocks.GYPSUM_STONE_STAIRS.get()).wall((Block)ModBlocks.GYPSUM_STONE_WALL.get()).getFamily();
    public static final ModBlockFamily GYPSUM_COBBLESTONE = ModBlockFamilies.familyBuilder((Block)ModBlocks.GYPSUM_COBBLESTONE.get()).button((Block)ModBlocks.GYPSUM_COBBLESTONE_BUTTON.get()).pressurePlate((Block)ModBlocks.GYPSUM_COBBLESTONE_PRESSURE_PLATE.get()).slab((Block)ModBlocks.GYPSUM_COBBLESTONE_SLAB.get()).stairs((Block)ModBlocks.GYPSUM_COBBLESTONE_STAIRS.get()).wall((Block)ModBlocks.GYPSUM_COBBLESTONE_WALL.get()).getFamily();
    public static final ModBlockFamily GYPSUM_COBBLESTONE_PATHWAY = ModBlockFamilies.familyBuilder((Block)ModBlocks.GYPSUM_COBBLESTONE_PATHWAY.get()).button((Block)ModBlocks.GYPSUM_COBBLESTONE_PATHWAY_BUTTON.get()).pressurePlate((Block)ModBlocks.GYPSUM_COBBLESTONE_PATHWAY_PRESSURE_PLATE.get()).slab((Block)ModBlocks.GYPSUM_COBBLESTONE_PATHWAY_SLAB.get()).stairs((Block)ModBlocks.GYPSUM_COBBLESTONE_PATHWAY_STAIRS.get()).wall((Block)ModBlocks.GYPSUM_COBBLESTONE_PATHWAY_WALL.get()).getFamily();
    public static final ModBlockFamily GYPSUM_PATHWAY = ModBlockFamilies.familyBuilder((Block)ModBlocks.GYPSUM_PATHWAY.get()).button((Block)ModBlocks.GYPSUM_PATHWAY_BUTTON.get()).pressurePlate((Block)ModBlocks.GYPSUM_PATHWAY_PRESSURE_PLATE.get()).slab((Block)ModBlocks.GYPSUM_PATHWAY_SLAB.get()).stairs((Block)ModBlocks.GYPSUM_PATHWAY_STAIRS.get()).wall((Block)ModBlocks.GYPSUM_PATHWAY_WALL.get()).getFamily();
    public static final ModBlockFamily GYPSUM_MIXED_PATH = ModBlockFamilies.familyBuilder((Block)ModBlocks.GYPSUM_MIXED_PATH.get()).button((Block)ModBlocks.GYPSUM_MIXED_PATH_BUTTON.get()).pressurePlate((Block)ModBlocks.GYPSUM_MIXED_PATH_PRESSURE_PLATE.get()).slab((Block)ModBlocks.GYPSUM_MIXED_PATH_SLAB.get()).stairs((Block)ModBlocks.GYPSUM_MIXED_PATH_STAIRS.get()).wall((Block)ModBlocks.GYPSUM_MIXED_PATH_WALL.get()).getFamily();
    public static final ModBlockFamily GYPSUM_TILES = ModBlockFamilies.familyBuilder((Block)ModBlocks.GYPSUM_TILES.get()).button((Block)ModBlocks.GYPSUM_TILES_BUTTON.get()).pressurePlate((Block)ModBlocks.GYPSUM_TILES_PRESSURE_PLATE.get()).slab((Block)ModBlocks.GYPSUM_TILES_SLAB.get()).stairs((Block)ModBlocks.GYPSUM_TILES_STAIRS.get()).wall((Block)ModBlocks.GYPSUM_TILES_WALL.get()).getFamily();
    public static final ModBlockFamily REFINED_GYPSUM_PANEL = ModBlockFamilies.familyBuilder((Block)ModBlocks.REFINED_GYPSUM_PANEL.get()).button((Block)ModBlocks.REFINED_GYPSUM_PANEL_BUTTON.get()).pressurePlate((Block)ModBlocks.REFINED_GYPSUM_PANEL_PRESSURE_PLATE.get()).slab((Block)ModBlocks.REFINED_GYPSUM_PANEL_SLAB.get()).stairs((Block)ModBlocks.REFINED_GYPSUM_PANEL_STAIRS.get()).wall((Block)ModBlocks.REFINED_GYPSUM_PANEL_WALL.get()).getFamily();
    public static final ModBlockFamily GYPSUM_STONE_PANEL = ModBlockFamilies.familyBuilder((Block)ModBlocks.GYPSUM_STONE_PANEL.get()).button((Block)ModBlocks.GYPSUM_STONE_PANEL_BUTTON.get()).pressurePlate((Block)ModBlocks.GYPSUM_STONE_PANEL_PRESSURE_PLATE.get()).slab((Block)ModBlocks.GYPSUM_STONE_PANEL_SLAB.get()).stairs((Block)ModBlocks.GYPSUM_STONE_PANEL_STAIRS.get()).wall((Block)ModBlocks.GYPSUM_STONE_PANEL_WALL.get()).getFamily();
    public static final ModBlockFamily REINFORCED_STONE = ModBlockFamilies.familyBuilder((Block)ModBlocks.REINFORCED_STONE.get()).button((Block)ModBlocks.REINFORCED_STONE_BUTTON.get()).pressurePlate((Block)ModBlocks.REINFORCED_STONE_PRESSURE_PLATE.get()).slab((Block)ModBlocks.REINFORCED_STONE_SLAB.get()).stairs((Block)ModBlocks.REINFORCED_STONE_STAIRS.get()).wall((Block)ModBlocks.REINFORCED_STONE_WALL.get()).getFamily();
    public static final ModBlockFamily REINFORCED_STONE_TILES = ModBlockFamilies.familyBuilder((Block)ModBlocks.REINFORCED_STONE_TILES.get()).button((Block)ModBlocks.REINFORCED_STONE_TILES_BUTTON.get()).pressurePlate((Block)ModBlocks.REINFORCED_STONE_TILES_PRESSURE_PLATE.get()).slab((Block)ModBlocks.REINFORCED_STONE_TILES_SLAB.get()).stairs((Block)ModBlocks.REINFORCED_STONE_TILES_STAIRS.get()).wall((Block)ModBlocks.REINFORCED_STONE_TILES_WALL.get()).getFamily();
    public static final ModBlockFamily REINFORCED_STONE_PATHWAY = ModBlockFamilies.familyBuilder((Block)ModBlocks.REINFORCED_STONE_PATHWAY.get()).button((Block)ModBlocks.REINFORCED_STONE_PATHWAY_BUTTON.get()).pressurePlate((Block)ModBlocks.REINFORCED_STONE_PATHWAY_PRESSURE_PLATE.get()).slab((Block)ModBlocks.REINFORCED_STONE_PATHWAY_SLAB.get()).stairs((Block)ModBlocks.REINFORCED_STONE_PATHWAY_STAIRS.get()).wall((Block)ModBlocks.REINFORCED_STONE_PATHWAY_WALL.get()).getFamily();
    public static final ModBlockFamily REINFORCED_STONE_PANEL = ModBlockFamilies.familyBuilder((Block)ModBlocks.REINFORCED_STONE_PANEL.get()).button((Block)ModBlocks.REINFORCED_STONE_PANEL_BUTTON.get()).pressurePlate((Block)ModBlocks.REINFORCED_STONE_PANEL_PRESSURE_PLATE.get()).slab((Block)ModBlocks.REINFORCED_STONE_PANEL_SLAB.get()).stairs((Block)ModBlocks.REINFORCED_STONE_PANEL_STAIRS.get()).wall((Block)ModBlocks.REINFORCED_STONE_PANEL_WALL.get()).getFamily();

    private static ModFamilyBuilder familyBuilder(Block pBaseBlock) {
        return new ModFamilyBuilder(pBaseBlock);
    }

    public static Stream<ModBlockFamily> getAllFamilies() {
        return MAP.values().stream();
    }

    private static final class ModFamilyBuilder {
        private final BlockFamily.Builder builder;
        private Block hangingSign;
        private Block wallHangingSign;

        private ModFamilyBuilder(Block baseBlock) {
            this.builder = new BlockFamily.Builder(baseBlock);
        }

        public ModFamilyBuilder button(Block button) {
            this.builder.m_175963_(button);
            return this;
        }

        public ModFamilyBuilder fence(Block fence) {
            this.builder.m_175982_(fence);
            return this;
        }

        public ModFamilyBuilder fenceGate(Block fenceGate) {
            this.builder.m_175984_(fenceGate);
            return this;
        }

        public ModFamilyBuilder pressurePlate(Block pressurePlate) {
            this.builder.m_175990_(pressurePlate);
            return this;
        }

        public ModFamilyBuilder sign(Block sign, Block wallSign) {
            this.builder.m_175965_(sign, wallSign);
            return this;
        }

        public ModFamilyBuilder hangingSign(Block hangingSign, Block wallHangingSign) {
            this.hangingSign = hangingSign;
            this.wallHangingSign = wallHangingSign;
            return this;
        }

        public ModFamilyBuilder slab(Block slab) {
            this.builder.m_175986_(slab);
            return this;
        }

        public ModFamilyBuilder stairs(Block stairs) {
            this.builder.m_175988_(stairs);
            return this;
        }

        public ModFamilyBuilder door(Block door) {
            this.builder.m_175980_(door);
            return this;
        }

        public ModFamilyBuilder trapdoor(Block trapdoor) {
            this.builder.m_175994_(trapdoor);
            return this;
        }

        public ModFamilyBuilder wall(Block wall) {
            this.builder.m_175996_(wall);
            return this;
        }

        public ModFamilyBuilder recipeGroupPrefix(String prefix) {
            this.builder.m_175968_(prefix);
            return this;
        }

        public ModFamilyBuilder recipeUnlockedBy(String unlock) {
            this.builder.m_175973_(unlock);
            return this;
        }

        public ModBlockFamily getFamily() {
            ModBlockFamily family = new ModBlockFamily(this.builder.m_175962_(), this.hangingSign, this.wallHangingSign);
            ModBlockFamily duplicate = MAP.put(family.getBaseBlock(), family);
            if (duplicate != null) {
                throw new IllegalStateException("Duplicate family definition for " + BuiltInRegistries.f_256975_.m_7981_((Object)family.getBaseBlock()));
            }
            return family;
        }
    }

    public static final class ModBlockFamily {
        private final BlockFamily family;
        private final Block hangingSign;
        private final Block wallHangingSign;

        private ModBlockFamily(BlockFamily family, Block hangingSign, Block wallHangingSign) {
            this.family = family;
            this.hangingSign = hangingSign;
            this.wallHangingSign = wallHangingSign;
        }

        public BlockFamily getFamily() {
            return this.family;
        }

        public Block getBaseBlock() {
            return this.family.m_175951_();
        }

        public Block get(BlockFamily.Variant variant) {
            return this.family.m_175952_(variant);
        }

        public boolean shouldGenerateRecipe(FeatureFlagSet featureFlagSet) {
            return this.family.m_245288_(featureFlagSet);
        }

        @Nullable
        public Block getHangingSign() {
            return this.hangingSign;
        }

        @Nullable
        public Block getWallHangingSign() {
            return this.wallHangingSign;
        }
    }
}

