/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.ai.navigation.DinosaurMoveHelper;
import net.vit.jurassicreborn.common.entities.ai.navigation.DinosaurPathNavigate;
import org.jetbrains.annotations.Nullable;

public abstract class AmphibianDinosaurEntity
extends DinosaurEntity {
    private boolean getOut = false;
    private boolean getInWater = false;
    private boolean blocked;
    protected final PathNavigation navigationSwimmer;
    protected final PathNavigation navigationLand;
    private final SmoothSwimmingMoveControl waterMoveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
    private final SmoothSwimmingLookControl waterLookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    private final DinosaurMoveHelper landMoveControl;
    private final LookControl landLookControl;
    private int waterTicks;
    private int landTicks;
    private int landCheckCooldown = 0;
    private int mediumSwitchCooldown = 0;
    private static final int MEDIUM_SWITCH_CD = 10;

    public AmphibianDinosaurEntity(Level world, EntityType type, Dinosaur dino) {
        super(world, (EntityType<? extends DinosaurEntity>)type, dino);
        this.navigationSwimmer = new WaterBoundPathNavigation((Mob)this, world);
        this.landMoveControl = new DinosaurMoveHelper(this);
        this.landLookControl = new LookControl((Mob)this);
        this.navigationLand = new DinosaurPathNavigate(this, world);
        this.navigationLand.m_7008_(true);
        this.f_21342_ = this.landMoveControl;
        this.f_21365_ = this.landLookControl;
        this.f_21344_ = this.navigationLand;
        this.blocked = false;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.m_274367_(1.5f);
        this.f_21345_.m_25352_(5, (Goal)new MoveUnderwaterGoal());
        this.f_21345_.m_25352_(10, (Goal)new FindWaterGoal());
        this.f_21345_.m_25352_(10, (Goal)new WanderGoal());
    }

    @Override
    public boolean isMovementBlocked() {
        return this.isCarcass() || this.m_5803_() || this.blocked;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.mediumSwitchCooldown > 0) {
            --this.mediumSwitchCooldown;
        }
        if (this.landCheckCooldown > 0) {
            --this.landCheckCooldown;
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            boolean inWaterNow = this.m_20069_();
            if (inWaterNow) {
                ++this.waterTicks;
                this.landTicks = 0;
                this.m_20301_(300);
                if (this.waterTicks > 200 && this.landCheckCooldown == 0) {
                    Vec3 nearbyLand = this.findNearbyLandQuick((Mob)this, 16, 6);
                    if (nearbyLand != null) {
                        this.getOut = true;
                        this.landCheckCooldown = 100;
                    } else {
                        this.getOut = false;
                        this.landCheckCooldown = 40;
                        this.waterTicks = 150;
                    }
                } else if (this.waterTicks <= 200) {
                    this.getOut = false;
                }
                this.getInWater = false;
                if (!this.getOut && this.mediumSwitchCooldown == 0 && !(this.f_21344_ instanceof WaterBoundPathNavigation)) {
                    this.f_21344_ = this.navigationSwimmer;
                    this.mediumSwitchCooldown = 10;
                } else if (this.getOut && this.mediumSwitchCooldown == 0 && !(this.f_21344_ instanceof GroundPathNavigation)) {
                    this.f_21344_ = this.navigationLand;
                    this.mediumSwitchCooldown = 10;
                }
            } else {
                ++this.landTicks;
                this.waterTicks = 0;
                this.landCheckCooldown = 0;
                int air = this.m_20146_() - 1;
                this.m_20301_(air);
                if (air <= -20) {
                    this.m_20301_(0);
                    this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
                }
                this.getInWater = air < 40;
                this.getOut = false;
                if (this.mediumSwitchCooldown == 0 && !(this.f_21344_ instanceof GroundPathNavigation)) {
                    this.f_21344_ = this.navigationLand;
                    this.mediumSwitchCooldown = 10;
                }
            }
        }
        if (this.m_20069_()) {
            if (this.f_21342_ != this.waterMoveControl) {
                this.f_21342_ = this.waterMoveControl;
                this.f_21365_ = this.waterLookControl;
            }
        } else if (this.f_21342_ != this.landMoveControl) {
            this.f_21342_ = this.landMoveControl;
            this.f_21365_ = this.landLookControl;
        }
    }

    @Override
    public void m_7023_(Vec3 vec) {
        boolean noInput;
        float strafe = (float)vec.f_82479_;
        float vertical = (float)vec.f_82480_;
        float forward = (float)vec.f_82481_;
        boolean bl = noInput = strafe == 0.0f && vertical == 0.0f && forward == 0.0f;
        if (!this.m_9236_().f_46443_ && this.m_20069_() && !this.isCarcass()) {
            this.m_19920_(0.15f, new Vec3((double)strafe, (double)vertical, (double)forward));
            this.m_6478_(MoverType.SELF, this.m_20184_());
            Vec3 movement = this.m_20184_().m_82542_(0.8, 0.8, 0.8);
            if (noInput && !this.getOut) {
                movement = movement.m_82520_(0.0, -0.01, 0.0);
            }
            this.m_20256_(movement);
        } else {
            super.m_7023_(vec);
        }
    }

    @Nullable
    private Vec3 findNearbyLandQuick(Mob mob, int hr, int vr) {
        BlockPos origin = mob.m_20183_();
        for (int attempts = 0; attempts < 8; ++attempts) {
            int dx = mob.m_217043_().m_188503_(hr * 2 + 1) - hr;
            int dy = mob.m_217043_().m_188503_(vr * 2 + 1) - vr;
            int dz = mob.m_217043_().m_188503_(hr * 2 + 1) - hr;
            BlockPos pos = origin.m_7918_(dx, dy, dz);
            BlockState ground = mob.m_9236_().m_8055_(pos);
            if (!ground.m_280555_()) continue;
            BlockPos above = pos.m_7494_();
            BlockState aboveState = mob.m_9236_().m_8055_(above);
            if (aboveState.m_60819_().m_76178_() && !this.hasAdjacentWater(mob, pos)) continue;
            return Vec3.m_82539_((Vec3i)above);
        }
        return null;
    }

    private boolean hasAdjacentWater(Mob mob, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockState adj = mob.m_9236_().m_8055_(pos.m_121945_(dir));
            if (adj.m_60819_().m_76178_()) continue;
            return true;
        }
        return false;
    }

    class MoveUnderwaterGoal
    extends Goal {
        private double x;
        private double y;
        private double z;
        private int retryCd = 0;
        private static final int TRY_EVERY = 20;
        private boolean failedToFindLand = false;

        public MoveUnderwaterGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            Vec3 target;
            if (this.retryCd > 0) {
                --this.retryCd;
                return false;
            }
            if (!AmphibianDinosaurEntity.this.m_20069_()) {
                return false;
            }
            if (AmphibianDinosaurEntity.this.m_5448_() != null) {
                return false;
            }
            if (AmphibianDinosaurEntity.this.getOut) {
                target = this.findNearbyLand((Mob)AmphibianDinosaurEntity.this, 16, 6);
                if (target == null) {
                    AmphibianDinosaurEntity.this.getOut = false;
                    AmphibianDinosaurEntity.this.waterTicks = 0;
                    this.failedToFindLand = true;
                    this.retryCd = 40;
                    return false;
                }
                this.failedToFindLand = false;
            } else {
                RandomSource rng = AmphibianDinosaurEntity.this.m_217043_();
                if (rng.m_188501_() < 0.5f && AmphibianDinosaurEntity.this.isBusy()) {
                    return false;
                }
                target = this.getRandomDeepWaterPos((Mob)AmphibianDinosaurEntity.this, 8, 4);
                if (target == null) {
                    this.retryCd = 20;
                    return false;
                }
            }
            this.x = target.f_82479_;
            this.y = target.f_82480_;
            this.z = target.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            if (AmphibianDinosaurEntity.this.m_5448_() != null) {
                return false;
            }
            if (AmphibianDinosaurEntity.this.getOut && AmphibianDinosaurEntity.this.m_20069_()) {
                return !AmphibianDinosaurEntity.this.m_21573_().m_26571_();
            }
            if (!AmphibianDinosaurEntity.this.getOut && !AmphibianDinosaurEntity.this.m_20069_()) {
                return false;
            }
            return !AmphibianDinosaurEntity.this.m_21573_().m_26571_();
        }

        public void m_8056_() {
            AmphibianDinosaurEntity.this.m_21573_().m_26519_(this.x, this.y, this.z, AmphibianDinosaurEntity.this.getOut ? 1.2 : 0.8);
            this.retryCd = 20;
        }

        public void m_8041_() {
            if (this.failedToFindLand && AmphibianDinosaurEntity.this.m_20069_()) {
                AmphibianDinosaurEntity.this.getOut = false;
                AmphibianDinosaurEntity.this.waterTicks = 0;
                this.failedToFindLand = false;
            }
        }

        public void m_8037_() {
            double distToTarget;
            if (AmphibianDinosaurEntity.this.getOut && AmphibianDinosaurEntity.this.f_19862_ && (distToTarget = AmphibianDinosaurEntity.this.m_20275_(this.x, this.y, this.z)) < 4.0) {
                Vec3 dm = AmphibianDinosaurEntity.this.m_20184_();
                AmphibianDinosaurEntity.this.m_20334_(dm.f_82479_, Math.max(dm.f_82480_, 0.15), dm.f_82481_);
            }
        }

        public boolean m_6767_() {
            return true;
        }

        @Nullable
        private Vec3 getRandomDeepWaterPos(Mob mob, int hr, int vr) {
            BlockState state;
            BlockPos pos;
            int dz;
            int dy;
            int dx;
            int i;
            BlockPos mobPos = mob.m_20183_();
            for (i = 0; i < 15; ++i) {
                dx = mob.m_217043_().m_188503_(hr * 2 + 1) - hr;
                dy = mob.m_217043_().m_188503_(vr * 2 + 1) - vr;
                dz = mob.m_217043_().m_188503_(hr * 2 + 1) - hr;
                pos = mobPos.m_7918_(dx, dy, dz);
                state = mob.m_9236_().m_8055_(pos);
                if (state.m_60819_().m_76178_()) continue;
                boolean isDeep = false;
                for (int up = 1; up <= 2; ++up) {
                    BlockState aboveState = mob.m_9236_().m_8055_(pos.m_6630_(up));
                    if (aboveState.m_60819_().m_76178_()) continue;
                    isDeep = true;
                    break;
                }
                if (!isDeep && dy >= 0) continue;
                return Vec3.m_82512_((Vec3i)pos);
            }
            for (i = 0; i < 8; ++i) {
                dx = mob.m_217043_().m_188503_(hr * 2 + 1) - hr;
                dy = -Math.abs(mob.m_217043_().m_188503_(vr + 1));
                dz = mob.m_217043_().m_188503_(hr * 2 + 1) - hr;
                pos = mobPos.m_7918_(dx, dy, dz);
                state = mob.m_9236_().m_8055_(pos);
                if (state.m_60819_().m_76178_()) continue;
                return Vec3.m_82512_((Vec3i)pos);
            }
            return null;
        }

        @Nullable
        private Vec3 findNearbyLand(Mob mob, int hr, int vr) {
            BlockPos origin = mob.m_20183_();
            for (int attempts = 0; attempts < 25; ++attempts) {
                int dx = mob.m_217043_().m_188503_(hr * 2 + 1) - hr;
                int dy = mob.m_217043_().m_188503_(vr * 2 + 1) - vr;
                int dz = mob.m_217043_().m_188503_(hr * 2 + 1) - hr;
                BlockPos pos = origin.m_7918_(dx, dy, dz);
                BlockState ground = mob.m_9236_().m_8055_(pos);
                if (!ground.m_280555_()) continue;
                BlockPos above = pos.m_7494_();
                BlockState aboveState = mob.m_9236_().m_8055_(above);
                BlockState aboveAboveState = mob.m_9236_().m_8055_(above.m_7494_());
                if (aboveState.m_280555_() || aboveAboveState.m_280555_() || aboveState.m_60819_().m_76178_() && !this.hasAdjacentWater(mob, pos)) continue;
                return Vec3.m_82539_((Vec3i)above);
            }
            return null;
        }

        private boolean hasAdjacentWater(Mob mob, BlockPos pos) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockState adj = mob.m_9236_().m_8055_(pos.m_121945_(dir));
                if (adj.m_60819_().m_76178_()) continue;
                return true;
            }
            return false;
        }
    }

    class FindWaterGoal
    extends Goal {
        private int cd = 0;

        public FindWaterGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.cd > 0) {
                --this.cd;
                return false;
            }
            return false;
        }
    }

    class WanderGoal
    extends RandomStrollGoal {
        public WanderGoal() {
            super((PathfinderMob)AmphibianDinosaurEntity.this, 1.0, 10);
        }

        public boolean m_8036_() {
            if (AmphibianDinosaurEntity.this.getInWater) {
                return false;
            }
            return !AmphibianDinosaurEntity.this.m_20069_() && super.m_8036_();
        }
    }
}

