/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.DinosaurEntities;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurHandler;

public class NigersaurusEntity
extends DinosaurEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(NigersaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public NigersaurusEntity(EntityType<NigersaurusEntity> type, Level world) {
        super(world, type, DinosaurHandler.NIGERSAURUS);
        this.setVariant(this.m_217043_().m_188503_(3));
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (EntityAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.NIGERSAURUS_LIVING;
            }
            case DYING: {
                return SoundHandler.NIGERSAURUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.NIGERSAURUS_HURT;
            }
            case CALLING: {
                return SoundHandler.NIGERSAURUS_LIVING;
            }
            case BEGGING: {
                return SoundHandler.NIGERSAURUS_HURT;
            }
            case ATTACKING: {
                return SoundHandler.NIGERSAURUS_ATTACKING;
            }
        }
        return null;
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(VARIANT, (Object)nbt.m_128451_("Variant"));
    }

    public void setVariant(int value) {
        this.f_19804_.m_135381_(VARIANT, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public ResourceLocation getTexture() {
        switch (this.getVariant()) {
            default: {
                return this.texture("green");
            }
            case 1: {
                return this.texture("brown");
            }
            case 2: 
        }
        return this.texture("white");
    }

    private ResourceLocation texture(String variant) {
        String formattedName = this.dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + formattedName + "/";
        String texture = baseTextures + formattedName;
        return this.isMale() ? new ResourceLocation("jurassicreborn", texture + "_male_adult_" + variant + ".png") : new ResourceLocation("jurassicreborn", texture + "_female_adult_" + variant + ".png");
    }
}

