/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.CeratosaurusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class CeratosaurusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.45f;

    public CeratosaurusDinosaur() {
        this.setName("Ceratosaurus");
        this.setScientificName("Ceratosaurus nasicornis");
        this.setFamily("Ceratosauridae");
        this.setLocation("United States");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(CeratosaurusEntity.class);
        this.setTimePeriod(TimePeriod.JURASSIC);
        this.setEggColorMale(9845306, 0);
        this.setEggColorFemale(13481886, 9123141);
        this.setHealth(10.0, 50.0);
        this.setSpeed(0.39999998807907106, 0.45f);
        this.setStorage(27);
        this.setAttackSpeed(1.4);
        this.setStrength(1.0, 22.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.25f, 3.45f);
        this.setSizeX(0.4f, 2.7f);
        this.setSizeY(0.3f, 3.5f);
        this.setDiet(Diet.CARNIVORE.get());
        this.setBones("skull", "tooth", "arm_bones", "claw", "foot_bones", "leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "tail_vertebrae");
        this.setHeadCubeName("Head");
        this.setScale(1.35f, 0.1f);
        this.setBreeding(false, 2, 6, 40, false, true);
        this.setImprintable(true);
        this.setMaxHerdSize(7);
        this.shouldDefendOffspring();
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", "tooth"}, {"", "leg_bones", "", "arm_bones", "claw"}, {"", "foot_bones", "", "", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_215816_, BiomeTags.f_207610_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

