/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.GallimimusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.FoodType;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class GallimimusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.41f;

    public GallimimusDinosaur() {
        this.setName("Gallimimus");
        this.setScientificName("Gallimimus bullatus");
        this.setFamily("Ornithomimidae");
        this.setLocation("Mongolia");
        this.setDinosaurClass(GallimimusEntity.class);
        this.setDinosaurType(Dinosaur.DinosaurType.SCARED);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(14006918, 13723928);
        this.setEggColorFemale(13417108, 11236157);
        this.setHealth(6.0, 30.0);
        this.setSpeed(0.3599999964237213, 0.41f);
        this.setStrength(1.0, 5.0);
        this.setMaximumAge(this.fromDays(35));
        this.setEyeHeight(0.45f, 2.15f);
        this.setSizeX(0.3f, 1.2f);
        this.setSizeY(0.55f, 2.25f);
        this.setStorage(27);
        this.setDiet(Diet.HERBIVORE.get().withModule(new Diet.DietModule(FoodType.INSECT).withCondition(entity -> entity.getAgePercentage() < 25)));
        this.setBones("arm_bones", "foot_bones", "leg_bones", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tail_vertebrae");
        this.setHeadCubeName("Head Base");
        this.setScale(1.05f, 0.1f);
        this.setImprintable(true);
        this.setFlee(true);
        this.setFlockSpeed(1.35f);
        this.setBreeding(false, 2, 6, 20, false, true);
        this.setJumpHeight(3);
        this.setCanClimb(true);
        String[][] recipe = new String[][]{{"", "", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder", ""}, {"", "leg_bones", "leg_bones", "arm_bones", ""}, {"", "foot_bones", "foot_bones", "", ""}};
        this.setRecipe(recipe);
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, Tags.Biomes.IS_DRY_OVERWORLD};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
        this.enableSkeleton();
    }
}

