/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TriceratopsEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class TriceratopsDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.35f;

    public TriceratopsDinosaur() {
        this.setName("Triceratops");
        this.setScientificName("Triceratops horridus");
        this.setFamily("Ceratopsidae");
        this.setLocation("United States");
        this.setDinosaurClass(TriceratopsEntity.class);
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(4211000, 0x1C1C1C);
        this.setEggColorFemale(9403254, 7563114);
        this.setSpeed(0.29999999403953553, 0.35f);
        this.setAttackSpeed(1.3);
        this.setHealth(10.0, 70.0);
        this.setStrength(5.0, 20.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.25f, 2.9f);
        this.setSizeX(0.15f, 2.5f);
        this.setSizeY(0.3f, 3.0f);
        this.setStorage(36);
        this.setDiet(Diet.HERBIVORE.get());
        this.setBones("front_leg_bones", "hind_leg_bones", "horn", "neck_vertebrae", "pelvis", "ribcage", "shoulder", "skull", "tail_vertebrae", "tooth");
        this.setHeadCubeName("Head");
        this.setScale(1.35f, 0.15f);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setAttackBias(400.0);
        this.setBreeding(false, 2, 6, 48, false, true);
        String[][] recipe = new String[][]{{"", "", "", "", "horn"}, {"tail_vertebrae", "pelvis", "ribcage", "neck_vertebrae", "skull"}, {"hind_leg_bones", "hind_leg_bones", "", "shoulder", "tooth"}, {"", "", "", "front_leg_bones", "front_leg_bones"}};
        this.setRecipe(recipe);
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, Tags.Biomes.IS_SPARSE};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
        this.enableSkeleton();
    }
}

