/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.TropeognathusEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class TropeognathusDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.3f;

    public TropeognathusDinosaur() {
        this.setName("Tropeognathus");
        this.setScientificName("Tropeognathus mesembrinus");
        this.setFamily("Anhangueridae");
        this.setLocation("Brazil");
        this.setDinosaurType(Dinosaur.DinosaurType.NEUTRAL);
        this.setDinosaurClass(TropeognathusEntity.class);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(5137515, 4731201);
        this.setEggColorFemale(6057073, 5062221);
        this.setHealth(10.0, 25.0);
        this.setSpeed(0.25000001192092897, 0.3f);
        this.setStrength(5.0, 20.0);
        this.setMaximumAge(this.fromDays(50));
        this.setEyeHeight(0.25f, 1.25f);
        this.setSizeX(0.15f, 1.0f);
        this.setSizeY(0.35f, 1.35f);
        this.setStorage(27);
        this.setDiet(Diet.PCARNIVORE.get());
        this.setBones("leg_bones", "pelvis", "skull", "ribcage", "tail_vertebrae", "teeth", "wing_bones");
        this.setHeadCubeName("Head");
        this.setScale(1.15f, 0.1f);
        this.setAttackBias(650.0);
        this.shouldDefendOffspring();
        this.setBreeding(false, 0, 6, 20, false, true);
        this.setImprintable(false);
        this.setAvianAnimal(true);
        this.setStorage(12);
        String[][] recipe = new String[][]{{"tail_vertebrae", "pelvis", "ribcage", "skull"}, {"", "leg_bones", "wing_bones", "teeth", ""}};
        this.setRecipe(recipe);
        this.enableSkeleton();
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_PLAINS, BiomeTags.f_207611_, BiomeTags.f_215816_, BiomeTags.f_207606_, BiomeTags.f_207607_, BiomeTags.f_207610_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
    }
}

