/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.Dinosaurs.DinosaurList;

import java.util.ArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.VelociraptorEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.SleepTime;
import net.vit.jurassicreborn.common.util.TimePeriod;

public class VelociraptorDinosaur
extends Dinosaur {
    public static final double SPEED = (double)0.4f;

    public VelociraptorDinosaur() {
        this.setName("Velociraptor");
        this.setScientificName("Velociraptor mongoliensis");
        this.setFamily("Dromaeosauridae");
        this.setLocation("Mongolia");
        this.setDinosaurClass(VelociraptorEntity.class);
        this.setDinosaurType(Dinosaur.DinosaurType.AGGRESSIVE);
        this.setTimePeriod(TimePeriod.CRETACEOUS);
        this.setEggColorMale(10510904, 6499601);
        this.setEggColorFemale(9533021, 5916473);
        this.setSpeed(0.3500000059604645, 0.4f);
        this.setAttackSpeed(1.9);
        this.setHealth(6.0, 35.0);
        this.setStrength(2.0, 10.0);
        this.setMaximumAge(this.fromDays(45));
        this.setEyeHeight(0.45f, 1.7f);
        this.setSizeX(0.5f, 1.0f);
        this.setSizeY(0.5f, 1.8f);
        this.setStorage(27);
        this.setDiet(Diet.CARNIVORE.get());
        this.setSleepTime(SleepTime.DIURNAL);
        this.setBones("claw", "arm_bones", "claw", "foot_bones", "leg_bones", "neck_vertebrae", "ribcage", "shoulder", "skull", "tail_vertebrae", "tooth", "pelvis");
        this.setHeadCubeName("Head");
        this.setScale(1.3f, 0.1f);
        this.setImprintable(true);
        this.setDefendOwner(true);
        this.setMaxHerdSize(7);
        this.setAttackBias(600.0);
        this.setCanClimb(true);
        this.setBreeding(false, 1, 7, 28, false, true);
        this.setJumpHeight(3);
        String[][] recipe = new String[][]{{"", "", "neck_vertebrae", "skull"}, {"tail_vertebrae", "pelvis", "ribcage", "shoulder"}, {"", "leg_bones", "arm_bones", "tooth"}, {"", "foot_bones", "claw", ""}};
        this.setRecipe(recipe);
        ArrayList<Object> biomeList = new ArrayList();
        TagKey[] tags = new TagKey[]{Tags.Biomes.IS_DENSE, BiomeTags.f_207611_, BiomeTags.f_207610_};
        ArrayList allBiomes = new ArrayList(ForgeRegistries.BIOMES.getValues());
        biomeList = new ArrayList<ResourceKey>(allBiomes.stream().filter(biome -> {
            boolean accept = false;
            for (TagKey tag : tags) {
                if (!ForgeRegistries.BIOMES.tags().getTag(tag).contains(biome)) continue;
                accept = true;
            }
            return accept;
        }).map(biome -> (ResourceKey)ForgeRegistries.BIOMES.getResourceKey(biome).get()).toList());
        this.setSpawn(1, biomeList);
        this.init();
        this.doSkeletonCheck();
    }

    protected void doSkeletonCheck() {
        this.enableSkeleton();
    }
}

