/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.EntityUtils;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;

public class TaskHelper {
    GoalSelector goalSelector;
    GoalSelector targetSelector;
    Class<? extends Entity> entityClass;
    Object2IntArrayMap<Goal> goalPriorityMap = new Object2IntArrayMap();

    public TaskHelper(GoalSelector Eselector, GoalSelector Tselector, Class<? extends Entity> entityClass) {
        this.goalSelector = Eselector;
        this.targetSelector = Tselector;
        this.entityClass = entityClass;
    }

    public TaskHelper(Class<? extends Entity> entityClass) {
        this.entityClass = entityClass;
    }

    public void setGoalSelector(GoalSelector selector) {
        if (selector != null) {
            this.goalSelector = selector;
        }
    }

    public void addGoal(Goal goal, int priority) {
        this.goalPriorityMap.put((Object)goal, priority);
    }

    public void setSelectorsAndRegisterGoals(GoalSelector goals, GoalSelector targets) {
        this.goalSelector = goals;
        this.targetSelector = targets;
        for (Goal goal : this.goalPriorityMap.keySet()) {
            if (goal instanceof TargetGoal) {
                this.targetSelector.m_25352_(((Integer)this.goalPriorityMap.apply((Object)goal)).intValue(), goal);
                continue;
            }
            this.goalSelector.m_25352_(((Integer)this.goalPriorityMap.apply((Object)goal)).intValue(), goal);
        }
    }

    public int getPriority(Goal goal) {
        return (Integer)this.goalPriorityMap.apply((Object)goal);
    }

    public List<Goal> getGoalsForPriority(int priority) {
        if (this.goalPriorityMap.containsValue(priority)) {
            return this.goalPriorityMap.keySet().stream().filter(goal -> (Integer)this.goalPriorityMap.apply(goal) == priority).collect(Collectors.toList());
        }
        return new ArrayList<Goal>();
    }
}

