/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.EntityUtils.ai;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.EntityUtils.GrowthStage;
import net.vit.jurassicreborn.common.util.BlockPosUtil;

public class Family {
    private UUID head;
    private final Set<UUID> parents = new HashSet<UUID>();
    private final Set<UUID> children = new HashSet<UUID>();
    private BlockPos home;
    private int stayHome;

    public Family(UUID ... parents) {
        if (parents != null && parents.length > 0) {
            this.head = parents[0];
            Collections.addAll(this.parents, parents);
        } else {
            this.head = null;
        }
    }

    public Family(Set<UUID> parents, Set<UUID> children, BlockPos home) {
        if (parents != null) {
            this.parents.addAll(parents);
        }
        if (children != null) {
            this.children.addAll(children);
        }
        this.home = home;
        if (this.head == null && !this.parents.isEmpty()) {
            this.head = this.parents.iterator().next();
        }
    }

    public boolean update(DinosaurEntity entity) {
        if (entity == null) {
            return false;
        }
        if (this.home == null || entity.m_20238_(BlockPosUtil.blockPosToVec(this.home)) > 4096.0) {
            this.home = BlockPosUtil.vecToBlockPos(entity.m_20182_());
        }
        Level world = entity.m_9236_();
        double centerX = 0.0;
        double centerZ = 0.0;
        HashSet<UUID> remove = new HashSet<UUID>();
        HashSet<DinosaurEntity> members = new HashSet<DinosaurEntity>();
        for (UUID parent : this.parents) {
            DinosaurEntity parentEntity = this.get(world, parent);
            if (parentEntity == null || parentEntity.m_21224_() || parentEntity.isCarcass()) {
                remove.add(parent);
                continue;
            }
            centerX += parentEntity.m_20185_();
            centerZ += parentEntity.m_20189_();
            members.add(parentEntity);
            parentEntity.family = this;
        }
        for (UUID child : this.children) {
            DinosaurEntity childEntity = this.get(world, child);
            if (childEntity == null || childEntity.m_21224_() || childEntity.isCarcass() || childEntity.getAgePercentage() > 50) {
                remove.add(child);
                continue;
            }
            members.add(childEntity);
            childEntity.family = this;
        }
        this.parents.removeAll(remove);
        this.children.removeAll(remove);
        if (this.parents.isEmpty()) {
            return true;
        }
        if (remove.size() > 0 && !this.parents.contains(this.head) || this.head == null) {
            this.head = this.parents.iterator().next();
        }
        centerX /= (double)this.parents.size();
        centerZ /= (double)this.parents.size();
        if (this.stayHome > 0) {
            --this.stayHome;
            centerX = this.home.m_123341_();
            centerZ = this.home.m_123343_();
        } else {
            centerX = (double)this.home.m_123341_() / 2.0 + centerX / 2.0;
            centerZ = (double)this.home.m_123343_() / 2.0 + centerZ / 2.0;
        }
        double centerDistance = entity.m_20275_(centerX, entity.m_20186_(), centerZ);
        RandomSource random = entity.m_217043_();
        if (random.m_188500_() * centerDistance > 128.0) {
            for (DinosaurEntity member : members) {
                if (member.getAttackTarget() != null || !member.m_21573_().m_26571_()) continue;
                int travelX = (int)(centerX + (double)random.m_188503_(4) - 2.0);
                int travelZ = (int)(centerZ + (double)random.m_188503_(4) - 2.0);
                int travelY = world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, travelX, travelZ);
                member.m_21573_().m_26519_((double)travelX + 0.5, (double)travelY, (double)travelZ + 0.5, 0.8);
            }
        }
        if (entity.m_217043_().m_188503_(50) == 0 && (entity.getDinosaur().shouldBreedAroundOffspring() || this.children.isEmpty())) {
            DinosaurEntity father = null;
            DinosaurEntity mother = null;
            for (DinosaurEntity member : members) {
                boolean ready;
                if (!this.parents.contains(member.m_20148_()) || !(ready = !member.shouldSleep() && member.getBreedCooldown() <= 0 && !member.isBreeding() && member.m_21223_() >= member.m_21233_() && member.getGrowthStage() == GrowthStage.ADULT)) continue;
                if (member.isMale()) {
                    father = father == null ? member : father;
                    continue;
                }
                mother = mother == null ? member : mother;
            }
            if (father != null && mother != null && father.m_20280_((Entity)mother) < 128.0) {
                father.m_21573_().m_5624_(mother, 1.0);
                mother.m_21573_().m_5624_(father, 1.0);
                father.breed(mother);
                mother.breed(father);
            }
        }
        return false;
    }

    private DinosaurEntity get(Level world, UUID uuid) {
        DinosaurEntity de;
        if (world == null || world.f_46443_ || uuid == null) {
            return null;
        }
        Entity e = ((ServerLevel)world).m_8791_(uuid);
        return e instanceof DinosaurEntity ? (de = (DinosaurEntity)e) : null;
    }

    public void addChild(UUID child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    public UUID getHead() {
        return this.head;
    }

    public void writeToNBT(CompoundTag familyTag) {
        ListTag children = new ListTag();
        for (UUID child : this.children) {
            CompoundTag childTag = new CompoundTag();
            childTag.m_128362_("UUID", child);
            children.add((Object)childTag);
        }
        familyTag.m_128365_("Children", (Tag)children);
        ListTag parents = new ListTag();
        for (UUID parent : this.parents) {
            CompoundTag parentTag = new CompoundTag();
            parentTag.m_128362_("UUID", parent);
            parents.add((Object)parentTag);
        }
        familyTag.m_128365_("Parents", (Tag)parents);
        if (this.home != null) {
            familyTag.m_128356_("Home", this.home.m_121878_());
        }
        familyTag.m_128405_("StayHome", this.stayHome);
    }

    public static Family readFromNBT(CompoundTag familyTag) {
        int i;
        HashSet<UUID> children = new HashSet<UUID>();
        HashSet<UUID> parents = new HashSet<UUID>();
        ListTag parentsList = familyTag.m_128437_("Parents", 10);
        ListTag childrenList = familyTag.m_128437_("Children", 10);
        for (i = 0; i < parentsList.size(); ++i) {
            CompoundTag parentTag = parentsList.m_128728_(i);
            parents.add(parentTag.m_128342_("UUID"));
        }
        for (i = 0; i < childrenList.size(); ++i) {
            CompoundTag childTag = childrenList.m_128728_(i);
            children.add(childTag.m_128342_("UUID"));
        }
        BlockPos home = familyTag.m_128441_("Home") ? BlockPos.m_122022_((long)familyTag.m_128454_("Home")) : null;
        Family family = new Family(parents, children, home);
        family.stayHome = familyTag.m_128451_("StayHome");
        return family;
    }

    public void setHome(BlockPos position, int stay) {
        this.home = position;
        this.stayHome = stay;
    }
}

