/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.EntityUtils.ai;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.Dinosaurs.Dinosaur;

public class Relationship {
    public static final int MAX_SCORE = 1000;
    private final UUID entity;
    private short score;

    public Relationship(UUID entity, short score) {
        this.entity = entity;
        this.score = score;
    }

    public boolean update(DinosaurEntity owner) {
        LivingEntity killer;
        DinosaurEntity de;
        LivingEntity currentTarget;
        DinosaurEntity other = this.get(owner);
        if (other == null) {
            return true;
        }
        boolean busy = !owner.m_21573_().m_26571_() || owner.m_5448_() != null;
        double intensity = Math.min(1.0, (double)Math.abs(this.score) / 1000.0);
        Dinosaur.DinosaurType type = owner.getDinosaur().getDinosaurType();
        if (this.score < 0) {
            if (!busy && type != Dinosaur.DinosaurType.SCARED && owner.m_217043_().m_188500_() < 0.3 * intensity) {
                owner.m_6710_((LivingEntity)other);
            }
        } else if (this.score > 0) {
            if ((type == Dinosaur.DinosaurType.AGGRESSIVE || type == Dinosaur.DinosaurType.NEUTRAL) && other.m_5448_() != null) {
                if (owner.m_217043_().m_188500_() < 0.3 * intensity) {
                    owner.m_6710_(other.m_5448_());
                }
            } else if (owner.family == null && !busy && owner.m_217043_().m_188500_() < 0.6 * intensity) {
                owner.m_21573_().m_5624_((Entity)other, 0.8);
            }
        }
        if ((currentTarget = owner.m_5448_()) != null && (currentTarget.m_21224_() || currentTarget instanceof DinosaurEntity && (de = (DinosaurEntity)currentTarget).isCarcass()) && (killer = currentTarget.m_21232_()) != null && killer.m_20148_().equals(this.entity)) {
            this.score = (short)(this.score + 100);
        }
        if (this.score > 1000) {
            this.score = (short)1000;
        } else if (this.score < -1000) {
            this.score = (short)-1000;
        }
        return other == owner;
    }

    public DinosaurEntity get(DinosaurEntity owner) {
        ServerLevel sl;
        Entity e;
        Level level;
        if (!owner.m_9236_().f_46443_ && (level = owner.m_9236_()) instanceof ServerLevel && (e = (sl = (ServerLevel)level).m_8791_(this.entity)) instanceof DinosaurEntity) {
            DinosaurEntity d = (DinosaurEntity)e;
            return d;
        }
        return null;
    }

    public void updateHerd(DinosaurEntity owner) {
        DinosaurEntity other;
        if (owner.family == null && (other = this.get(owner)) != null) {
            double distSq = other.m_20280_((Entity)owner);
            if (distSq < 32.0) {
                this.score = (short)(this.score + 2);
            } else if (this.score > 0 && owner.m_217043_().m_188500_() > 0.8) {
                this.score = (short)(this.score - 1);
            }
            if (this.score > 1000) {
                this.score = (short)1000;
            } else if (this.score < -1000) {
                this.score = (short)-1000;
            }
        }
    }

    public void onAttacked(double damage) {
        int newScore = this.score - (int)Math.round(damage);
        if (newScore > 1000) {
            newScore = 1000;
        }
        if (newScore < -1000) {
            newScore = -1000;
        }
        this.score = (short)newScore;
    }

    public void setFamily() {
        this.score = (short)1000;
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Relationship)) return false;
        Relationship rel = (Relationship)obj;
        if (!rel.entity.equals(this.entity)) return false;
        return true;
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128362_("UUID", this.entity);
        tag.m_128376_("Score", this.score);
    }

    public static Relationship readFromNBT(CompoundTag tag) {
        UUID uuid = tag.m_128342_("UUID");
        short score = tag.m_128448_("Score");
        return new Relationship(uuid, score);
    }

    public UUID getUUID() {
        return this.entity;
    }

    public short getScore() {
        return this.score;
    }
}

