/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.EntityUtils.ai;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;

public class SmartBodyHelper
extends BodyRotationControl {
    private static final float MAX_ROTATE = 75.0f;
    private static final int HISTORY_SIZE = 10;
    private final Mob entity;
    private int rotateTime;
    private float targetYawHead;
    private final double[] histPosX = new double[10];
    private final double[] histPosZ = new double[10];

    public SmartBodyHelper(Mob entity) {
        super(entity);
        this.entity = entity;
    }

    public void m_8121_() {
        DinosaurEntity d;
        Mob mob;
        if (this.entity.m_21224_() || (mob = this.entity) instanceof DinosaurEntity && (d = (DinosaurEntity)mob).isCarcass()) {
            return;
        }
        System.arraycopy(this.histPosX, 0, this.histPosX, 1, this.histPosX.length - 1);
        System.arraycopy(this.histPosZ, 0, this.histPosZ, 1, this.histPosZ.length - 1);
        this.histPosX[0] = this.entity.m_20185_();
        this.histPosZ[0] = this.entity.m_20189_();
        double dx = this.delta(this.histPosX);
        double dz = this.delta(this.histPosZ);
        double distSq = dx * dx + dz * dz;
        if (distSq > 2.5E-7) {
            float moveAngle = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            this.entity.f_20883_ += Mth.m_14177_((float)(moveAngle - this.entity.f_20883_)) * 0.6f;
            if (!this.entity.m_21573_().m_26571_()) {
                float yawDelta = Mth.m_14177_((float)(moveAngle - this.entity.m_146908_())) * 0.4f;
                this.entity.m_146922_(this.entity.m_146908_() + yawDelta);
            }
            this.rotateTime = 0;
            this.targetYawHead = this.entity.f_20885_;
            return;
        }
        if (this.entity.m_20197_().isEmpty() || !(this.entity.m_20197_().get(0) instanceof LivingEntity)) {
            float limit = 75.0f;
            if (Math.abs(this.entity.f_20885_ - this.targetYawHead) > 15.0f) {
                this.rotateTime = 0;
                this.targetYawHead = this.entity.f_20885_;
            } else {
                ++this.rotateTime;
                int speed = 30;
                if (this.rotateTime > 30) {
                    float t = Math.max(1.0f - (float)(this.rotateTime - 30) / 30.0f, 0.0f);
                    limit = t * 75.0f;
                }
            }
            this.entity.f_20883_ = this.approach(this.entity.f_20885_, this.entity.f_20883_, limit);
        }
    }

    private float approach(float target, float current, float limit) {
        float delta = Mth.m_14177_((float)(target - current));
        if (delta < -limit) {
            delta = -limit;
        } else if (delta > limit) {
            delta = limit;
        }
        return target - delta * 0.67f;
    }

    private double delta(double[] arr) {
        return this.mean(arr, 0) - this.mean(arr, 5);
    }

    private double mean(double[] arr, int start) {
        double sum = 0.0;
        int half = 5;
        for (int i = 0; i < half; ++i) {
            sum += arr[i + start];
        }
        return sum / (double)half;
    }
}

