/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LegSolver {
    public final Leg[] legs;

    public LegSolver(Leg ... legs) {
        this.legs = legs;
    }

    public final void update(LivingEntity entity, float scale) {
        this.update((Entity)entity, entity.f_20883_, scale);
    }

    public final void update(Entity entity, float yaw, float scale) {
        double sideTheta = Math.toRadians(yaw);
        double sideX = Math.cos(sideTheta) * (double)scale;
        double sideZ = Math.sin(sideTheta) * (double)scale;
        double forwardTheta = sideTheta + 1.5707963267948966;
        double forwardX = Math.cos(forwardTheta) * (double)scale;
        double forwardZ = Math.sin(forwardTheta) * (double)scale;
        for (Leg leg : this.legs) {
            leg.update(entity, sideX, sideZ, forwardX, forwardZ, scale);
        }
    }

    public static class Leg {
        public final float forward;
        public final float side;
        private final float range;
        private float height;
        private float prevHeight;

        public Leg(float forward, float side, float range) {
            this.forward = forward;
            this.side = side;
            this.range = range;
        }

        public final float getHeight(float delta) {
            return this.prevHeight + (this.height - this.prevHeight) * delta;
        }

        public void update(Entity entity, double sideX, double sideZ, double forwardX, double forwardZ, float scale) {
            this.prevHeight = this.height;
            double x = entity.m_20185_() + sideX * (double)this.side + forwardX * (double)this.forward;
            double y = entity.m_20186_();
            double z = entity.m_20189_() + sideZ * (double)this.side + forwardZ * (double)this.forward;
            float settled = this.settle(entity, x, y, z, this.height);
            this.height = Mth.m_14036_((float)settled, (float)(-this.range * scale), (float)(this.range * scale));
        }

        private float settle(Entity entity, double x, double y, double z, float height) {
            Level level = entity.m_9236_();
            int ix = Mth.m_14107_((double)x);
            int iy = Mth.m_14107_((double)(y + 0.001));
            int iz = Mth.m_14107_((double)z);
            BlockPos pos = new BlockPos(ix, iy, iz);
            float dist = this.getDistance(level, pos);
            double fracY = y % 1.0;
            dist = (double)(1.0f - dist) < 0.001 ? this.getDistance(level, pos.m_7495_()) + (float)fracY : (dist -= 1.0f - (float)fracY);
            boolean onGround = entity.m_20096_();
            if (onGround && height <= dist) {
                return height == dist ? height : Math.min(height + this.getFallSpeed(), dist);
            }
            if (height > 0.0f) {
                return Math.max(height - this.getRiseSpeed(), dist);
            }
            return height;
        }

        private float getDistance(Level level, BlockPos pos) {
            BlockState state = level.m_8055_(pos);
            VoxelShape shape = state.m_60812_((BlockGetter)level, pos);
            if (shape.m_83281_()) {
                return 1.0f;
            }
            AABB aabb = shape.m_83215_();
            double top = Math.min(aabb.f_82292_, 1.0);
            return (float)(1.0 - top);
        }

        protected float getFallSpeed() {
            return 0.3f;
        }

        protected float getRiseSpeed() {
            return 0.5f;
        }
    }
}

