/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities;

import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.vit.jurassicreborn.client.JurassicClient;
import net.vit.jurassicreborn.common.entities.DinosaurEntities.DilophosaurusEntity;

public class VenomEntity
extends Projectile {
    public static final double GRAVITY = 0.0075;
    public static final double DRAG = 0.99;
    public static final int MAX_LIFETIME = 200;
    public static final int OWNER_GRACE_TICKS = 6;
    private UUID ownerIdCache;

    public VenomEntity(EntityType<? extends VenomEntity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    public VenomEntity(EntityType<? extends VenomEntity> type, Level level, LivingEntity owner) {
        this(type, level);
        this.m_5602_((Entity)owner);
        if (owner != null) {
            this.ownerIdCache = owner.m_20148_();
        }
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.f_19797_ > 200) {
            this.m_146870_();
            return;
        }
        Vec3 start = this.m_20182_();
        Vec3 motion = this.m_20184_();
        Vec3 end = start.m_82549_(motion);
        BlockHitResult blockHit = this.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        double speed = motion.m_82553_();
        AABB aabb = this.m_20191_().m_82369_(motion).m_82400_(0.35 + speed * 0.75);
        EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)start, (Vec3)end, (AABB)aabb, this::m_5603_);
        EntityHitResult chosen = null;
        if (entityHit != null) {
            chosen = entityHit;
        }
        if (blockHit != null && blockHit.m_6662_() != HitResult.Type.MISS) {
            if (chosen == null) {
                chosen = blockHit;
            } else {
                double dEntity;
                double dBlock = start.m_82554_(blockHit.m_82450_());
                if (dBlock + 0.15 < (dEntity = start.m_82554_(chosen.m_82450_()))) {
                    chosen = blockHit;
                }
            }
        }
        if (chosen != null && chosen.m_6662_() != HitResult.Type.MISS) {
            this.m_6532_((HitResult)chosen);
        }
        this.m_6034_(this.m_20185_() + motion.f_82479_, this.m_20186_() + motion.f_82480_, this.m_20189_() + motion.f_82481_);
        if (!this.m_20068_()) {
            motion = motion.m_82520_(0.0, -0.0075, 0.0);
        }
        motion = motion.m_82490_(0.99);
        this.m_20256_(motion);
        if (this.m_9236_().f_46443_) {
            JurassicClient.spawnVenomParticles(this);
        }
        Vec3 v = this.m_20184_();
        double horiz = Math.sqrt(v.f_82479_ * v.f_82479_ + v.f_82481_ * v.f_82481_);
        float yRot = (float)Math.toDegrees(Math.atan2(v.f_82479_, v.f_82481_));
        float xRot = (float)Math.toDegrees(Math.atan2(v.f_82480_, horiz));
        this.m_146922_(yRot);
        this.m_146926_(xRot);
        this.f_19859_ = yRot;
        this.f_19860_ = xRot;
    }

    protected boolean m_5603_(Entity e) {
        if (e == null || !e.m_6084_() || e.m_5833_() || e.m_7306_((Entity)this)) {
            return false;
        }
        Entity owner = this.m_19749_();
        if (owner != null) {
            if (this.f_19797_ <= 6) {
                if (e == owner) {
                    return false;
                }
                if (this.ownerIdCache != null && this.ownerIdCache.equals(e.m_20148_())) {
                    return false;
                }
            }
            Entity eRoot = e.m_20201_();
            Entity oRoot = owner.m_20201_();
            if (eRoot != null && oRoot != null && eRoot == oRoot) {
                return false;
            }
            if (e.m_20159_() && e.m_20202_() == owner) {
                return false;
            }
            if (owner.m_20159_() && owner.m_20202_() == e) {
                return false;
            }
        }
        return super.m_5603_(e);
    }

    protected void m_6532_(HitResult hit) {
        super.m_6532_(hit);
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult ehr) {
        super.m_5790_(ehr);
        Entity victim = ehr.m_82443_();
        Entity shooter = this.m_19749_();
        if (victim == shooter) {
            return;
        }
        if (shooter instanceof DilophosaurusEntity) {
            DilophosaurusEntity dilo = (DilophosaurusEntity)shooter;
            if (victim instanceof DilophosaurusEntity && victim != dilo.m_5448_()) {
                return;
            }
        }
        if (victim instanceof LivingEntity) {
            DamageSource damageSource;
            LivingEntity living = (LivingEntity)victim;
            if (shooter instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)shooter;
                damageSource = this.m_9236_().m_269111_().m_269104_((Entity)this, (Entity)le);
            } else {
                damageSource = this.m_9236_().m_269111_().m_269390_((Entity)this, shooter);
            }
            DamageSource src = damageSource;
            living.m_6469_(src, 4.0f);
            living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 300, 0, false, true));
            living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 300, 0, false, true));
        }
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void makeLaserStraight(boolean straight) {
        this.m_20242_(straight);
    }
}

