/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HurtByTargetGoal
extends TargetGoal {
    private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.m_148352_().m_148355_().m_26893_();
    private static final int ALERT_RANGE_Y = 10;
    private boolean alertSameType;
    private int timestamp;
    private final Class<?>[] toIgnoreDamage;
    @Nullable
    private Class<?>[] toIgnoreAlert;

    public HurtByTargetGoal(PathfinderMob mob, Class<?> ... toIgnoreDamage) {
        super((Mob)mob, true);
        this.toIgnoreDamage = toIgnoreDamage;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        int last = this.f_26135_.m_21213_();
        LivingEntity attacker = this.f_26135_.m_21188_();
        if (last == this.timestamp || attacker == null) {
            return false;
        }
        if (attacker.m_6095_() == EntityType.f_20532_ && this.f_26135_.m_9236_().m_46469_().m_46207_(GameRules.f_46127_)) {
            return false;
        }
        for (Class<?> c : this.toIgnoreDamage) {
            if (!c.isAssignableFrom(attacker.getClass())) continue;
            return false;
        }
        return this.m_26150_(attacker, HURT_BY_TARGETING);
    }

    public HurtByTargetGoal setAlertOthers(Class<?> ... reinforcementTypes) {
        this.alertSameType = true;
        this.toIgnoreAlert = reinforcementTypes;
        return this;
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.f_26135_.m_21188_());
        this.f_26137_ = this.f_26135_.m_5448_();
        this.timestamp = this.f_26135_.m_21213_();
        this.f_26138_ = 300;
        if (this.alertSameType) {
            this.alertOthers();
        }
        super.m_8056_();
    }

    protected void alertOthers() {
        double follow = this.m_7623_();
        AABB box = AABB.m_82333_((Vec3)this.f_26135_.m_20182_()).m_82377_(follow, 10.0, follow);
        List allies = this.f_26135_.m_9236_().m_6443_(this.f_26135_.getClass(), box, EntitySelector.f_20408_);
        LivingEntity aggressor = this.f_26135_.m_21188_();
        if (aggressor == null) {
            return;
        }
        for (Mob ally : allies) {
            if (ally == this.f_26135_ || ally.m_5448_() != null || ally.m_7307_((Entity)aggressor)) continue;
            Mob mob = this.f_26135_;
            if (mob instanceof TamableAnimal) {
                TamableAnimal tmA = (TamableAnimal)mob;
                if (ally instanceof TamableAnimal) {
                    TamableAnimal tmB = (TamableAnimal)ally;
                    if (tmA.m_269323_() != tmB.m_269323_()) continue;
                }
            }
            if (this.toIgnoreAlert != null) {
                boolean ignored = false;
                for (Class<?> c : this.toIgnoreAlert) {
                    if (ally.getClass() != c) continue;
                    ignored = true;
                    break;
                }
                if (ignored) continue;
            }
            this.alertOther(ally, aggressor);
        }
    }

    protected void alertOther(Mob mob, LivingEntity target) {
        mob.m_6710_(target);
    }
}

