/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.AABB;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.util.GameRuleHandler;

public class MateEntityAI
extends Goal {
    private static final double SEARCH_RANGE = 16.0;
    private static final double START_SPEED = 1.0;
    private static final double TOUCH_GROWTH = 0.5;
    private static final int MAX_TICKS = 400;
    private static final int RECALC_COOLDOWN = 10;
    private final DinosaurEntity self;
    private DinosaurEntity partner;
    private int life;
    private int nextRecalc;

    public MateEntityAI(DinosaurEntity self) {
        this.self = self;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (this.self.m_9236_().f_46443_) {
            return false;
        }
        if (!((GameRules.BooleanValue)this.self.m_9236_().m_46469_().m_46170_(GameRuleHandler.DINO_BREEDING)).m_46223_()) {
            return false;
        }
        if (this.self.isBusy() || this.self.isCarcass() || this.self.m_5803_()) {
            return false;
        }
        if (this.self.getAgePercentage() < 90) {
            return false;
        }
        if (this.self.getBreedCooldown() > 0) {
            return false;
        }
        if (this.self.isPregnant()) {
            return false;
        }
        Class<DinosaurEntity> cls = this.self.getClass().asSubclass(DinosaurEntity.class);
        AABB box = this.self.m_20191_().m_82400_(16.0);
        Predicate<DinosaurEntity> candidate = d -> d != this.self && d.m_6084_() && !d.isCarcass() && !d.m_5803_() && d.getClass() == cls && d.isMale() != this.self.isMale() && d.getAgePercentage() >= 90 && d.getBreedCooldown() <= 0 && !d.isPregnant();
        List list = this.self.m_9236_().m_6443_(cls, box, candidate::test);
        this.partner = list.stream().min(Comparator.comparingDouble(arg_0 -> ((DinosaurEntity)this.self).m_20280_(arg_0))).orElse(null);
        return this.partner != null;
    }

    public boolean m_8045_() {
        if (this.self.m_9236_().f_46443_) {
            return false;
        }
        if (this.partner == null || !this.partner.m_6084_() || this.partner.isCarcass() || this.partner.m_5803_()) {
            return false;
        }
        if (this.self.isBusy() || this.self.isCarcass() || this.self.m_5803_()) {
            return false;
        }
        return this.life < 400;
    }

    public void m_8056_() {
        this.life = 0;
        this.nextRecalc = 0;
        if (this.partner != null && this.partner.getBreedCooldown() <= 0) {
            this.self.breed(this.partner);
            this.partner.breed(this.self);
        }
        if (this.partner != null) {
            this.self.m_21573_().m_5624_((Entity)this.partner, 1.0);
        }
    }

    public void m_8037_() {
        if (this.partner == null) {
            return;
        }
        ++this.life;
        if (--this.nextRecalc <= 0) {
            this.nextRecalc = 10;
            this.self.m_21573_().m_5624_((Entity)this.partner, 1.0);
        }
        if (this.self.m_20191_().m_82400_(0.5).m_82381_(this.partner.m_20191_())) {
            this.self.setAnimation(EntityAnimation.MATING.get());
            this.self.getMetabolism().decreaseEnergy(1000);
            this.self.m_21573_().m_26573_();
            this.m_8041_();
        }
    }

    public void m_8041_() {
        this.self.m_21573_().m_26573_();
        this.partner = null;
        this.life = 0;
        this.nextRecalc = 0;
    }
}

