/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;
import net.vit.jurassicreborn.common.entities.DinosaurEntity;
import net.vit.jurassicreborn.common.entities.EntityUtils.Diet;
import net.vit.jurassicreborn.common.entities.EntityUtils.FoodType;

public class TargetCarcassAI
extends Goal {
    private final DinosaurEntity dino;
    private DinosaurEntity carcass;

    public TargetCarcassAI(DinosaurEntity dino) {
        this.dino = dino;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        boolean carnivore;
        if (this.dino.isCarcass() || this.dino.m_5803_() || !this.dino.m_6084_()) {
            return false;
        }
        if (!this.dino.getMetabolism().isHungry()) {
            return false;
        }
        if (this.dino.isBusy()) {
            return false;
        }
        if (this.dino.m_217043_().m_188503_(10) != 0) {
            return false;
        }
        Diet diet = this.dino.getDinosaur().getDiet();
        boolean bl = carnivore = diet.canEat(this.dino, FoodType.MEAT) || diet.canEat(this.dino, FoodType.FISH);
        if (!carnivore) {
            return false;
        }
        AABB search = this.dino.m_20191_().m_82400_(16.0);
        List inRange = this.dino.m_9236_().m_45976_(DinosaurEntity.class, search);
        double bestDistSq = Double.MAX_VALUE;
        DinosaurEntity best = null;
        for (DinosaurEntity other : inRange) {
            double distSq;
            if (other == this.dino || !other.isCarcass() || !((distSq = this.dino.m_20280_((Entity)other)) < bestDistSq)) continue;
            bestDistSq = distSq;
            best = other;
        }
        this.carcass = best;
        return this.carcass != null;
    }

    public void m_8056_() {
        this.dino.m_6710_((LivingEntity)this.carcass);
        this.dino.m_21573_().m_5624_((Entity)this.carcass, (double)1.2f);
    }

    public void m_8041_() {
        this.carcass = null;
    }

    public boolean m_8045_() {
        return false;
    }
}

