/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.vit.jurassicreborn.common.entities.ai.util.RingXZTraverser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AIUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static BlockPos findIntersect(BlockPos center, int radius, BlockPos start) {
        int dz;
        int dx = start.m_123341_() - center.m_123341_();
        double dist = Math.sqrt((double)dx * (double)dx + (double)(dz = start.m_123343_() - center.m_123343_()) * (double)dz);
        if (dist < (double)radius) {
            return start;
        }
        double scale = (double)radius / dist;
        return new BlockPos(center.m_123341_() + Mth.m_14107_((double)((double)dx * scale + 0.5)), center.m_123342_(), center.m_123343_() + Mth.m_14107_((double)((double)dz * scale + 0.5)));
    }

    public static BlockPos computePosToward(BlockPos current, BlockPos target, int move) {
        int dz;
        int dx = target.m_123341_() - current.m_123341_();
        double dist = Math.sqrt((double)dx * (double)dx + (double)(dz = target.m_123343_() - current.m_123343_()) * (double)dz);
        if (dist < (double)move) {
            return target;
        }
        double scale = (double)move / dist;
        return new BlockPos(current.m_123341_() + Mth.m_14107_((double)((double)dx * scale + 0.5)), current.m_123342_(), current.m_123343_() + Mth.m_14107_((double)((double)dz * scale + 0.5)));
    }

    public static BlockPos findSurface(Level level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return pos;
        }
        BlockPos.MutableBlockPos m = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        while (level.m_6425_((BlockPos)m).m_76170_() || !level.m_6425_((BlockPos)m).m_76178_()) {
            m.m_122184_(0, 1, 0);
            if (level.m_46749_((BlockPos)m)) continue;
            break;
        }
        return m.m_7949_();
    }

    public static BlockPos findSurface(LivingEntity entity) {
        if (!entity.m_20069_()) {
            return null;
        }
        Level level = entity.m_9236_();
        BlockPos start = entity.m_20183_().m_6625_(Mth.m_14143_((float)(entity.m_20206_() * 0.5f)));
        return AIUtils.findSurface(level, start);
    }

    public static int getWaterDepth(LivingEntity entity) {
        return AIUtils.getWaterDepth(entity, false);
    }

    public static int getWaterDepth(LivingEntity entity, boolean fromEntity) {
        if (!entity.m_20069_()) {
            return 0;
        }
        Level level = entity.m_9236_();
        BlockPos origin = entity.m_20183_();
        int depth = 0;
        BlockPos.MutableBlockPos m = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        while (level.m_46749_((BlockPos)m) && AIUtils.isSourceWater(level, (BlockPos)m)) {
            m.m_122184_(0, 1, 0);
            ++depth;
        }
        m.m_122190_((Vec3i)origin).m_122184_(0, -1, 0);
        if (fromEntity) {
            depth = 0;
        }
        while (level.m_46749_((BlockPos)m) && AIUtils.isSourceWater(level, (BlockPos)m)) {
            m.m_122184_(0, -1, 0);
            ++depth;
        }
        return depth + 1;
    }

    public static BlockPos getBottom(LivingEntity entity) {
        return BlockPos.m_274561_((double)entity.m_20185_(), (double)(entity.m_20186_() - (double)AIUtils.getWaterDepth(entity, true)), (double)entity.m_20189_());
    }

    public static BlockPos findShore(Level level, BlockPos center) {
        int MAX_R = 32;
        for (int radius = 1; radius <= 32; ++radius) {
            for (BlockPos ringPos : new RingXZTraverser(center, radius)) {
                if (!level.m_46749_(ringPos) || AIUtils.isWaterColumn(level, ringPos)) continue;
                int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ringPos.m_123341_(), ringPos.m_123343_());
                BlockPos ground = new BlockPos(ringPos.m_123341_(), y - 1, ringPos.m_123343_());
                if (AIUtils.isWaterColumn(level, ground)) continue;
                return ground;
            }
        }
        return null;
    }

    private static boolean isWaterColumn(Level level, BlockPos pos) {
        FluidState fs = level.m_6425_(pos);
        return fs.m_76152_() == Fluids.f_76193_ && !fs.m_76178_();
    }

    private static boolean isSourceWater(Level level, BlockPos pos) {
        FluidState state = level.m_6425_(pos);
        return state.m_76152_() == Fluids.f_76193_ && state.m_76170_();
    }

    public static void plotCircle(int x0, int y0, int radius) {
        int x = radius;
        int decision = 1 - x;
        for (int y = 0; y <= x; ++y) {
            AIUtils.logPixel(x0 + x, y0 + y);
            AIUtils.logPixel(x0 + y, y0 + x);
            AIUtils.logPixel(x0 + -x, y0 + y);
            AIUtils.logPixel(x0 + -y, y0 + x);
            AIUtils.logPixel(x0 + -x, y0 + -y);
            AIUtils.logPixel(x0 + -y, y0 + -x);
            AIUtils.logPixel(x0 + x, y0 + -y);
            AIUtils.logPixel(x0 + y, y0 + -x);
            if (decision <= 0) {
                decision += 2 * y + 1;
                continue;
            }
            decision += 2 * (y - --x) + 1;
        }
    }

    private static void logPixel(int x, int y) {
        LOGGER.info("x={}  y={}", (Object)x, (Object)y);
    }

    private AIUtils() {
    }
}

