/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.ai.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.core.BlockPos;

public class RingXZTraverser
implements Iterable<BlockPos>,
Iterator<BlockPos> {
    private final BlockPos center;
    private final int r;
    private int x;
    private int z;
    private int y;
    private int side = 0;
    private int stepsOnSide = 0;
    private int stepsRemaining;
    private boolean started = false;

    public RingXZTraverser(BlockPos center, int radius) {
        this.center = center;
        this.r = Math.max(0, radius);
        this.y = center.m_123342_();
        if (this.r == 0) {
            this.x = center.m_123341_();
            this.z = center.m_123343_();
            this.stepsRemaining = 1;
        } else {
            this.x = center.m_123341_() - this.r;
            this.z = center.m_123343_() - this.r;
            this.stepsRemaining = 8 * this.r;
        }
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.stepsRemaining > 0;
    }

    @Override
    public BlockPos next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.started) {
            this.advance();
        }
        this.started = true;
        --this.stepsRemaining;
        return new BlockPos(this.x, this.y, this.z);
    }

    private void advance() {
        if (this.r == 0) {
            return;
        }
        int edgeLen = 2 * this.r;
        switch (this.side) {
            case 0: {
                ++this.x;
                break;
            }
            case 1: {
                ++this.z;
                break;
            }
            case 2: {
                --this.x;
                break;
            }
            case 3: {
                --this.z;
            }
        }
        ++this.stepsOnSide;
        if (this.stepsOnSide >= edgeLen) {
            this.stepsOnSide = 0;
            this.side = this.side + 1 & 3;
        }
    }
}

