/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.animal;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.render.entity.animation.PoseHandler;
import net.vit.jurassicreborn.client.sounds.SoundHandler;
import net.vit.jurassicreborn.common.RebornConfig;
import net.vit.jurassicreborn.common.entities.EntityUtils.Animatable;
import net.vit.jurassicreborn.common.entities.EntityUtils.GrowthStage;
import net.vit.jurassicreborn.common.entities.EntityUtils.ai.SmartBodyHelper;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.items.ModItems;

public class GoatEntity
extends Animal
implements Animatable,
IEntityAdditionalSpawnData {
    public static final PoseHandler<GoatEntity> BILLY_POSE_HANDLER = new PoseHandler("goat_billy", Lists.newArrayList((Object[])new GrowthStage[]{GrowthStage.ADULT}));
    public static final PoseHandler<GoatEntity> KID_POSE_HANDLER = new PoseHandler("goat_kid", Lists.newArrayList((Object[])new GrowthStage[]{GrowthStage.INFANT}));
    public static final PoseHandler<GoatEntity> NANNY_POSE_HANDLER = new PoseHandler("goat_nanny", Lists.newArrayList((Object[])new GrowthStage[]{GrowthStage.ADULT}));
    private static final EntityDataAccessor<Boolean> WATCHER_IS_RUNNING = SynchedEntityData.m_135353_(GoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WATCHER_IS_BILLY = SynchedEntityData.m_135353_(GoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> WATCHER_VARIANT = SynchedEntityData.m_135353_(GoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Animation animation;
    private int animationTick;
    private int animationLength;
    private boolean billy;
    private Variant variant = Variant.JURASSIC_PARK;
    private boolean milked;
    private boolean inLava;

    public GoatEntity(EntityType<? extends GoatEntity> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.animationTick = 0;
        this.setAnimation(EntityAnimation.IDLE.get());
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper((Mob)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.6));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WATCHER_IS_RUNNING, (Object)false);
        this.f_19804_.m_135372_(WATCHER_IS_BILLY, (Object)false);
        this.f_19804_.m_135372_(WATCHER_VARIANT, (Object)Variant.JURASSIC_PARK.ordinal());
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob mate) {
        GoatEntity baby = (GoatEntity)((EntityType)ModEntities.GOAT.get()).m_20615_((Level)level);
        if (baby != null) {
            baby.m_6518_((ServerLevelAccessor)level, level.m_6436_(this.m_20183_()), MobSpawnType.BREEDING, null, null);
        }
        return baby;
    }

    @Override
    public boolean isCarcass() {
        return false;
    }

    @Override
    public boolean isMoving() {
        float dz;
        float dx = (float)(this.m_20185_() - this.f_19790_);
        return dx * dx + (dz = (float)(this.m_20189_() - this.f_19792_)) * dz > 0.001f;
    }

    @Override
    public boolean isClimbing() {
        return false;
    }

    public boolean m_6069_() {
        return (this.m_20069_() || this.m_20077_()) && !this.m_20096_();
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(WATCHER_IS_RUNNING);
    }

    @Override
    public boolean isMarineCreature() {
        return false;
    }

    @Override
    public boolean shouldUseInertia() {
        return true;
    }

    public boolean m_5803_() {
        return false;
    }

    @Override
    public boolean inWater() {
        return this.m_20069_();
    }

    @Override
    public boolean inLava() {
        return this.inLava;
    }

    @Override
    public boolean canUseGrowthStage(GrowthStage growthStage) {
        return false;
    }

    private boolean kidPackIncomplete() {
        return KID_POSE_HANDLER.getAnimationLength(EntityAnimation.IDLE.get(), GrowthStage.INFANT) <= 0.0f;
    }

    private GrowthStage effectiveGrowthStage() {
        if (this.m_6162_() && this.kidPackIncomplete()) {
            return GrowthStage.ADULT;
        }
        return this.m_6162_() ? GrowthStage.INFANT : GrowthStage.ADULT;
    }

    private PoseHandler<?> effectivePoseHandler() {
        if (this.m_6162_() && this.kidPackIncomplete()) {
            return (Boolean)this.f_19804_.m_135370_(WATCHER_IS_BILLY) != false ? BILLY_POSE_HANDLER : NANNY_POSE_HANDLER;
        }
        if (this.m_6162_()) {
            return KID_POSE_HANDLER;
        }
        return (Boolean)this.f_19804_.m_135370_(WATCHER_IS_BILLY) != false ? BILLY_POSE_HANDLER : NANNY_POSE_HANDLER;
    }

    private Animation coerceSupported(Animation desired) {
        GrowthStage gs;
        PoseHandler<?> ph = this.effectivePoseHandler();
        if (ph.getAnimationLength(desired, gs = this.effectiveGrowthStage()) > 0.0f) {
            return desired;
        }
        Animation idle = EntityAnimation.IDLE.get();
        if (ph.getAnimationLength(idle, gs) > 0.0f) {
            return idle;
        }
        for (Animation a : EntityAnimation.getAnimations()) {
            if (!(ph.getAnimationLength(a, gs) > 0.0f)) continue;
            return a;
        }
        return idle;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 10 == 0) {
            this.inLava = this.m_20077_();
        }
        if (this.animation != null && this.animation != EntityAnimation.IDLE.get()) {
            boolean shouldHold = EntityAnimation.getAnimation(this.animation).shouldHold();
            if (this.animationTick < this.animationLength) {
                ++this.animationTick;
            } else if (!shouldHold) {
                this.animationTick = 0;
                this.setAnimation(EntityAnimation.IDLE.get());
            } else {
                this.animationTick = this.animationLength - 1;
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(WATCHER_IS_RUNNING, (Object)((double)this.m_6113_() > this.m_21133_(Attributes.f_22279_) ? 1 : 0));
        }
    }

    public Animation[] getAnimations() {
        return EntityAnimation.getAnimations();
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation newAnimation) {
        Animation coerced = this.coerceSupported(newAnimation);
        Animation old = this.animation;
        this.animation = coerced;
        if (old != coerced) {
            this.animationTick = 0;
            this.animationLength = (int)this.effectivePoseHandler().getAnimationLength(this.animation, this.effectiveGrowthStage());
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, coerced);
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public GrowthStage getGrowthStage() {
        return this.effectiveGrowthStage();
    }

    public PoseHandler getPoseHandler() {
        return this.effectivePoseHandler();
    }

    public Type getGoatType() {
        boolean isBilly = (Boolean)this.f_19804_.m_135370_(WATCHER_IS_BILLY);
        return this.m_6162_() ? Type.KID : (isBilly ? Type.BILLY : Type.NANNY);
    }

    public void m_8032_() {
        super.m_8032_();
        if (this.getAnimation() == EntityAnimation.IDLE.get()) {
            this.setAnimation(EntityAnimation.SPEAK.get());
        }
    }

    protected SoundEvent m_7515_() {
        return SoundHandler.GOAT_LIVING;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundHandler.GOAT_HURT;
    }

    protected SoundEvent m_5592_() {
        return SoundHandler.GOAT_DEATH;
    }

    protected float m_6118_() {
        return 0.62f;
    }

    public void m_8035_() {
        super.m_8035_();
        this.milked = false;
        this.setAnimation(EntityAnimation.EATING.get());
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!(itemstack.m_41720_() != Items.f_42446_ || player.m_7500_() || this.m_6162_() || this.billy)) {
            player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            itemstack.m_41774_(1);
            if (itemstack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42455_));
            } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42455_))) {
                player.m_36176_(new ItemStack((ItemLike)Items.f_42455_), false);
            }
            this.milked = true;
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        this.billy = this.m_217043_().m_188499_();
        this.variant = Variant.values()[this.m_217043_().m_188503_(Variant.values().length)];
        this.f_19804_.m_135381_(WATCHER_IS_BILLY, (Object)this.billy);
        this.f_19804_.m_135381_(WATCHER_VARIANT, (Object)this.variant.ordinal());
        return super.m_6518_(level, difficulty, reason, spawnData, tag);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Billy", this.billy);
        tag.m_128344_("Variant", (byte)this.variant.ordinal());
        tag.m_128379_("Milked", this.milked);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.billy = tag.m_128471_("Billy");
        this.variant = Variant.values()[tag.m_128445_("Variant")];
        this.milked = tag.m_128471_("Milked");
        this.f_19804_.m_135381_(WATCHER_IS_BILLY, (Object)this.billy);
        this.f_19804_.m_135381_(WATCHER_VARIANT, (Object)this.variant.ordinal());
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.billy);
        buffer.writeByte(this.variant.ordinal());
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.billy = buf.readBoolean();
        this.variant = Variant.values()[buf.readByte()];
        this.f_19804_.m_135381_(WATCHER_IS_BILLY, (Object)this.billy);
        this.f_19804_.m_135381_(WATCHER_VARIANT, (Object)this.variant.ordinal());
    }

    protected void m_7472_(DamageSource src, int looting, boolean recentlyHit) {
        this.m_20000_((ItemLike)Items.f_42454_, this.f_19796_.m_188503_(2) + 1);
        if (this.f_19796_.m_188499_()) {
            this.m_5552_(new ItemStack((ItemLike)(this.f_19796_.m_188499_() ? Blocks.f_50041_ : Blocks.f_50106_), 1), 0.0f);
        }
        this.m_20000_(this.m_6060_() ? (ItemLike)ModItems.GOAT_COOKED.get() : (ItemLike)ModItems.GOAT_RAW.get(), this.f_19796_.m_188503_(2) + 1);
    }

    protected float m_6121_() {
        return super.m_6121_() * 0.8f;
    }

    public Variant getVariant() {
        return Variant.values()[(Integer)this.f_19804_.m_135370_(WATCHER_VARIANT)];
    }

    public int m_5792_() {
        return 3;
    }

    public int m_8100_() {
        return 300;
    }

    public boolean m_7848_(Animal other) {
        if (other == this) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        if (this.billy != ((GoatEntity)other).billy) {
            return this.m_27593_() && other.m_27593_();
        }
        return false;
    }

    public static boolean checkGoatSpawnRules(EntityType<GoatEntity> type, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return RebornConfig.spawnGoats && Animal.m_218104_(type, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public static enum Variant {
        JURASSIC_WORLD,
        JURASSIC_PARK,
        JPOG;

    }

    public static enum Type {
        BILLY,
        NANNY,
        KID;

    }
}

