/*
 * Decompiled with CFR 0.152.
 */
package net.vit.jurassicreborn.common.entities.animal;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.vit.jurassicreborn.client.render.entity.animation.EntityAnimation;
import net.vit.jurassicreborn.client.render.entity.animation.FixedChainBuffer;
import net.vit.jurassicreborn.client.render.entity.animation.PoseHandler;
import net.vit.jurassicreborn.common.RebornConfig;
import net.vit.jurassicreborn.common.entities.EntityUtils.Animatable;
import net.vit.jurassicreborn.common.entities.EntityUtils.GrowthStage;
import net.vit.jurassicreborn.common.entities.EntityUtils.ai.SmartBodyHelper;
import net.vit.jurassicreborn.common.entities.ModEntities;
import net.vit.jurassicreborn.common.entities.animal.CrabEntity;
import net.vit.jurassicreborn.common.items.ModItems;
import org.jetbrains.annotations.Nullable;

public class SharkEntity
extends Animal
implements Animatable,
IEntityAdditionalSpawnData {
    public static final PoseHandler<SharkEntity> SHARK_POSE_HANDLER = new PoseHandler("shark", Lists.newArrayList((Object[])new GrowthStage[]{GrowthStage.ADULT}));
    private static final EntityDataAccessor<Boolean> SHARK_IS_RUNNING = SynchedEntityData.m_135353_(SharkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public FixedChainBuffer tailBuffer;
    private Animation animation;
    private int animationTick;
    private int animationLength;

    public SharkEntity(EntityType<SharkEntity> sharkEntityEntityType, Level world) {
        super(sharkEntityEntityType, world);
        this.m_274367_(1.0f);
        this.animationTick = 0;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.setAnimation(EntityAnimation.IDLE.get());
    }

    public boolean m_6040_() {
        return true;
    }

    public int m_6062_() {
        return 4800;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Player.class}));
        this.f_21345_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Goat.class, false));
        this.f_21345_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, CrabEntity.class, false));
        this.f_21345_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Squid.class, false));
        this.f_21345_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, TropicalFish.class, false));
        this.f_21345_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Salmon.class, false));
        this.f_21345_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Cod.class, false));
        this.f_21345_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, false));
        this.f_21345_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractFish.class, false));
        this.f_21345_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Drowned.class, false));
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new WaterBoundPathNavigation((Mob)this, pLevel);
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        ArrayList<ItemStack> itemsToDrop = new ArrayList<ItemStack>();
        if (this.m_6060_()) {
            itemsToDrop.add(new ItemStack((ItemLike)ModItems.SHARK_MEAT_COOKED.get(), this.m_217043_().m_188503_(2) + 1));
        } else {
            itemsToDrop.add(new ItemStack((ItemLike)ModItems.SHARK_MEAT_RAW.get(), this.m_217043_().m_188503_(2) + 1));
        }
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        for (ItemStack stack : itemsToDrop) {
            this.m_19983_(stack);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return new SharkEntity((EntityType<SharkEntity>)((EntityType)ModEntities.SHARK.get()), (Level)p_146743_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag;
        float f = (float)this.m_21051_(Attributes.f_22281_).m_22135_();
        int i = 0;
        if (entityIn instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)entityIn;
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)l.m_6336_());
            i += EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if (flag = entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof LivingEntity) {
                LivingEntity l = (LivingEntity)entityIn;
                l.m_147240_((double)((float)i * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if ((j = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
                entityIn.m_20254_(j * 4);
            }
            if (entityIn instanceof Player) {
                ItemStack itemstack1;
                Player entityplayer = (Player)entityIn;
                ItemStack itemstack = this.m_21205_();
                ItemStack itemStack = itemstack1 = entityplayer.m_6117_() ? entityplayer.m_21211_() : ItemStack.f_41583_;
                if (!itemstack.m_41619_() && !itemstack1.m_41619_() && itemstack.m_41720_().canDisableShield(itemstack, itemstack1, (LivingEntity)entityplayer, (LivingEntity)this) && itemstack1.m_41720_().canPerformAction(itemstack1, ToolActions.SHIELD_BLOCK)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
                    if (this.f_19796_.m_188501_() < f1) {
                        entityplayer.m_36335_().m_41524_(itemstack1.m_41720_(), 100);
                        this.m_9236_().m_7605_((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SHARK_IS_RUNNING, (Object)false);
    }

    protected float m_6108_() {
        return 1.0f;
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper((Mob)this);
    }

    @Override
    public boolean isCarcass() {
        return false;
    }

    @Override
    public boolean isMoving() {
        double powx = this.m_20184_().f_82479_;
        powx *= powx;
        double powz = this.m_20184_().f_82481_;
        powz *= powz;
        double powy = this.m_20184_().f_82480_;
        return powx + powz + (powy *= powy) > (double)0.001f;
    }

    @Override
    public boolean isClimbing() {
        return false;
    }

    @Override
    public boolean inWater() {
        return this.m_20069_();
    }

    @Override
    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(SHARK_IS_RUNNING);
    }

    @Override
    public boolean inLava() {
        return this.m_20077_();
    }

    @Override
    public boolean canUseGrowthStage(GrowthStage growthStage) {
        return growthStage.equals((Object)GrowthStage.ADULT);
    }

    @Override
    public boolean isMarineCreature() {
        return true;
    }

    @Override
    public boolean shouldUseInertia() {
        return true;
    }

    @Override
    public GrowthStage getGrowthStage() {
        return GrowthStage.ADULT;
    }

    public PoseHandler<SharkEntity> getPoseHandler() {
        return SHARK_POSE_HANDLER;
    }

    public boolean m_6063_() {
        return false;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation newAnimation) {
        Animation oldAnimation = this.animation;
        this.animation = newAnimation;
        if (oldAnimation != newAnimation) {
            this.animationTick = 0;
            this.animationLength = (int)this.getPoseHandler().getAnimationLength(this.animation, this.getGrowthStage());
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, newAnimation);
        }
    }

    public Animation[] getAnimations() {
        return EntityAnimation.getAnimations();
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public static boolean checkSharkSpawnRules(EntityType<SharkEntity> type, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return RebornConfig.spawnSharks && pos.m_123342_() <= level.m_5736_() && level.m_6425_(pos).m_205070_(FluidTags.f_13131_) && level.m_6425_(pos.m_7494_()).m_205070_(FluidTags.f_13131_);
    }
}

